/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.qps;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.ProviderFilter;
import org.apache.servicecomb.qps.Config;
import org.apache.servicecomb.qps.QpsConst;
import org.apache.servicecomb.qps.QpsControllerManager;
import org.apache.servicecomb.qps.QpsStrategy;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.springframework.core.env.Environment;

public class ProviderFlowControlFilter
extends AbstractFilter
implements ProviderFilter {
    private final QpsControllerManager qpsControllerMgr;

    public ProviderFlowControlFilter(Environment environment) {
        this.qpsControllerMgr = new QpsControllerManager(true, environment);
    }

    public int getOrder() {
        return -1990;
    }

    public String getName() {
        return "provider-flow-control";
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        if (!Config.INSTANCE.isProviderEnabled()) {
            return nextNode.onFilter(invocation);
        }
        String microserviceName = invocation.getContext("x-cse-src-microservice");
        QpsStrategy qpsStrategy = this.qpsControllerMgr.getOrCreate(microserviceName, invocation);
        if (qpsStrategy.isLimitNewRequest()) {
            CommonExceptionData errorData = new CommonExceptionData("provider request rejected by flow control.");
            return CompletableFuture.failedFuture((Throwable)new InvocationException(QpsConst.TOO_MANY_REQUESTS_STATUS, (Object)errorData));
        }
        return nextNode.onFilter(invocation);
    }

    @VisibleForTesting
    public QpsControllerManager getQpsControllerMgr() {
        return this.qpsControllerMgr;
    }
}

