/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx.accesslog.impl;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import org.apache.servicecomb.transport.rest.vertx.accesslog.AccessLogGenerator;
import org.apache.servicecomb.transport.rest.vertx.accesslog.AccessLogParam;
import org.apache.servicecomb.transport.rest.vertx.accesslog.element.impl.LocalHostItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogHandler
implements Handler<RoutingContext> {
    private static Logger LOGGER = LoggerFactory.getLogger((String)"accesslog");
    private AccessLogGenerator accessLogGenerator;

    public AccessLogHandler(String rawPattern) {
        this.accessLogGenerator = new AccessLogGenerator(rawPattern);
    }

    public void handle(RoutingContext context) {
        AccessLogParam<RoutingContext> accessLogParam = this.getRoutingContextAccessLogParam(context);
        context.response().endHandler(event -> LOGGER.info(this.accessLogGenerator.generateLog(accessLogParam)));
        context.next();
    }

    private AccessLogParam<RoutingContext> getRoutingContextAccessLogParam(RoutingContext context) {
        AccessLogParam<RoutingContext> accessLogParam = new AccessLogParam<RoutingContext>();
        accessLogParam.setStartMillisecond(System.currentTimeMillis()).setContextData(context);
        accessLogParam.setLocalAddress(LocalHostItem.getLocalAddress(accessLogParam));
        return accessLogParam;
    }
}

