/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.transport;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.shareddata.Shareable;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.foundation.vertx.metrics.DefaultVertxMetricsFactory;
import org.apache.servicecomb.foundation.vertx.metrics.MetricsOptionsEx;

public class TransportVertxFactory {
    private static final String LOCAL_MAP_NAME = "scb";
    private static final String INFO = "transport-vertx-info";

    public DefaultVertxMetricsFactory getMetricsFactory() {
        TransportVertxInfo info = (TransportVertxInfo)this.getTransportVertx().sharedData().getLocalMap(LOCAL_MAP_NAME).get((Object)INFO);
        return info.metricsFactory;
    }

    public Vertx getTransportVertx() {
        return VertxUtils.getVertxMap().computeIfAbsent("transport", this::createTransportVertx);
    }

    private Vertx createTransportVertx(String name) {
        TransportVertxInfo info = new TransportVertxInfo();
        Vertx vertx = VertxUtils.init((VertxOptions)info.vertxOptions);
        info.metricsFactory.setVertx(vertx, info.vertxOptions);
        vertx.sharedData().getLocalMap(LOCAL_MAP_NAME).put((Object)INFO, (Object)info);
        return vertx;
    }

    static class TransportVertxInfo
    implements Shareable {
        public VertxOptions vertxOptions = new VertxOptions();
        public DefaultVertxMetricsFactory metricsFactory = new DefaultVertxMetricsFactory();
        public MetricsOptionsEx metricsOptionsEx = (MetricsOptionsEx)this.metricsFactory.newOptions();

        public TransportVertxInfo() {
            this.vertxOptions.setMetricsOptions((MetricsOptions)this.metricsOptionsEx);
        }
    }
}

