/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.NumericMonitor;
import com.netflix.servo.monitor.NumericMonitorWrapper;
import com.netflix.servo.monitor.SpectatorMonitor;
import com.netflix.servo.monitor.SpectatorMonitorWrapper;
import com.netflix.servo.tag.TagList;

class MonitorWrapper<T>
extends AbstractMonitor<T> {
    private final Monitor<T> monitor;

    static <T> MonitorWrapper<T> create(TagList tags, Monitor<T> monitor) {
        if (monitor instanceof NumericMonitor) {
            return monitor instanceof SpectatorMonitor ? new SpectatorMonitorWrapper(tags, (NumericMonitor)monitor) : new NumericMonitorWrapper(tags, (NumericMonitor)monitor);
        }
        return new MonitorWrapper<T>(tags, monitor);
    }

    MonitorWrapper(TagList tags, Monitor<T> monitor) {
        super(monitor.getConfig().withAdditionalTags(tags));
        this.monitor = monitor;
    }

    @Override
    public T getValue(int pollerIdx) {
        return this.monitor.getValue();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MonitorWrapper)) {
            return false;
        }
        MonitorWrapper m = (MonitorWrapper)obj;
        return this.config.equals(m.getConfig()) && this.monitor.equals(m.monitor);
    }

    public int hashCode() {
        int result = this.getConfig().hashCode();
        result = 31 * result + this.monitor.hashCode();
        return result;
    }

    public String toString() {
        return "MonitorWrapper{config=" + this.config + ", monitor=" + this.monitor + '}';
    }
}

