/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.servicecomb.common.rest.AbstractRestInvocation;
import org.apache.servicecomb.common.rest.filter.HttpServerFilter;
import org.apache.servicecomb.common.rest.locator.OperationLocator;
import org.apache.servicecomb.common.rest.locator.ServicePathManager;
import org.apache.servicecomb.core.definition.MicroserviceVersionMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.core.provider.consumer.ReactiveResponseExecutor;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.foundation.vertx.http.VertxServerRequestToHttpServletRequest;
import org.apache.servicecomb.foundation.vertx.http.VertxServerResponseToHttpServletResponse;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersionRule;

public class EdgeInvocation
extends AbstractRestInvocation {
    public static final String EDGE_INVOCATION_CONTEXT = "edgeInvocationContext";
    protected String microserviceName;
    protected MicroserviceVersionRule microserviceVersionRule;
    protected MicroserviceVersionMeta latestMicroserviceVersionMeta;
    protected ReferenceConfig referenceConfig;
    protected String versionRule = "0.0.0+";
    protected RoutingContext routingContext;

    public void init(String microserviceName, RoutingContext context, String path, List<HttpServerFilter> httpServerFilters) {
        this.microserviceName = microserviceName;
        this.requestEx = new VertxServerRequestToHttpServletRequest(context, path);
        this.responseEx = new VertxServerResponseToHttpServletResponse(context.response());
        this.routingContext = context;
        this.httpServerFilters = httpServerFilters;
        this.requestEx.setAttribute("servicecomb-rest-request", (Object)this.requestEx);
    }

    public void edgeInvoke() {
        this.findMicroserviceVersionMeta();
        this.findRestOperation(this.latestMicroserviceVersionMeta.getMicroserviceMeta());
        this.scheduleInvocation();
    }

    protected void findMicroserviceVersionMeta() {
        String versionRule = this.chooseVersionRule();
        String appId = RegistryUtils.getAppId();
        int idxAt = this.microserviceName.indexOf(":");
        if (idxAt != -1) {
            appId = this.microserviceName.substring(0, idxAt);
        }
        this.microserviceVersionRule = RegistryUtils.getServiceRegistry().getAppManager().getOrCreateMicroserviceVersionRule(appId, this.microserviceName, versionRule);
        this.latestMicroserviceVersionMeta = (MicroserviceVersionMeta)this.microserviceVersionRule.getLatestMicroserviceVersion();
        if (this.latestMicroserviceVersionMeta == null) {
            throw new ServiceCombException(String.format("Failed to find latest MicroserviceVersionMeta, appId=%s, microserviceName=%s, versionRule=%s.", appId, this.microserviceName, versionRule));
        }
    }

    public void setVersionRule(String versionRule) {
        this.versionRule = versionRule;
    }

    protected String chooseVersionRule() {
        return this.versionRule;
    }

    protected OperationLocator locateOperation(ServicePathManager servicePathManager) {
        return servicePathManager.consumerLocateOperation(this.requestEx.getRequestURI(), this.requestEx.getMethod());
    }

    protected void createInvocation() {
        ReferenceConfig referenceConfig = new ReferenceConfig();
        referenceConfig.setMicroserviceVersionRule(this.microserviceVersionRule);
        referenceConfig.setTransport("");
        this.invocation = InvocationFactory.forConsumer((ReferenceConfig)referenceConfig, (OperationMeta)this.restOperationMeta.getOperationMeta(), null);
        this.invocation.setSync(false);
        this.invocation.setEdge(true);
        this.invocation.getHandlerContext().put(EDGE_INVOCATION_CONTEXT, Vertx.currentContext());
        this.invocation.setResponseExecutor((Executor)new ReactiveResponseExecutor());
        this.routingContext.put("servicecomb-rest-invocation-context", (Object)this.invocation);
    }

    protected void setContext() throws Exception {
    }
}

