/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.jaxrs.processor.annotation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.Parameter;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.servicecomb.swagger.generator.core.OperationGenerator;
import org.apache.servicecomb.swagger.generator.core.ParameterAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.core.SwaggerGeneratorContext;
import org.apache.servicecomb.swagger.generator.core.processor.parameter.AbstractParameterProcessor;
import org.apache.servicecomb.swagger.generator.core.utils.ParamUtils;

public class BeanParamAnnotationProcessor
implements ParameterAnnotationProcessor {
    public static final Set<Class<?>> SUPPORTED_PARAM_ANNOTATIONS = new HashSet();
    public static final String SETTER_METHOD_PREFIX = "set";

    public void process(Object annotation, OperationGenerator operationGenerator, int paramIdx) {
        Class<?> beanParamClazz = operationGenerator.getProviderMethod().getParameterTypes()[paramIdx];
        HashMap<String, Parameter> swaggerParamMap = new HashMap<String, Parameter>();
        try {
            this.traversalParamField(operationGenerator, beanParamClazz, swaggerParamMap);
        }
        catch (IntrospectionException | IllegalArgumentException e) {
            throw new Error(String.format("Processing param failed, method=%s:%s, beanParamIdx=%d", operationGenerator.getProviderMethod().getDeclaringClass().getName(), operationGenerator.getProviderMethod().getName(), paramIdx), e);
        }
        Field[] declaredProducerFields = beanParamClazz.getDeclaredFields();
        Arrays.stream(declaredProducerFields).map(declaredProducerField -> (Parameter)swaggerParamMap.get(declaredProducerField.getName())).filter(Objects::nonNull).forEach(arg_0 -> ((OperationGenerator)operationGenerator).addProviderParameter(arg_0));
    }

    private void traversalParamField(OperationGenerator operationGenerator, Class<?> beanParamClazz, Map<String, Parameter> swaggerParamMap) throws IntrospectionException {
        for (Field beanParamField : beanParamClazz.getDeclaredFields()) {
            if (this.fieldShouldIgnore(beanParamField) || beanParamField.isSynthetic()) continue;
            Parameter swaggerParam = this.generateSwaggerParam(operationGenerator, beanParamField.getAnnotations(), beanParamField.getGenericType());
            if (null == swaggerParam) {
                swaggerParam = this.processFieldSetter(operationGenerator, beanParamClazz, beanParamField);
            }
            if (null == swaggerParam) {
                throw new IllegalArgumentException(String.format("There is a field[%s] cannot be mapped to swagger param. Maybe you should tag @JsonIgnore on it.", beanParamField.getName()));
            }
            swaggerParamMap.put(beanParamField.getName(), swaggerParam);
        }
    }

    private Parameter processFieldSetter(OperationGenerator operationGenerator, Class<?> beanParamClazz, Field beanParamField) throws IntrospectionException {
        Parameter swaggerParam = null;
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(beanParamField.getName(), beanParamClazz);
        Method writeMethod = propertyDescriptor.getWriteMethod();
        if (null != writeMethod) {
            swaggerParam = this.generateSwaggerParam(operationGenerator, writeMethod.getAnnotations(), beanParamField.getGenericType());
        }
        return swaggerParam;
    }

    private Parameter generateSwaggerParam(OperationGenerator operationGenerator, Annotation[] annotations, Type genericType) {
        String defaultValue = null;
        for (Annotation fieldAnnotation : annotations) {
            if (!SUPPORTED_PARAM_ANNOTATIONS.contains(fieldAnnotation.annotationType())) {
                if (!(fieldAnnotation instanceof DefaultValue)) continue;
                defaultValue = ((DefaultValue)fieldAnnotation).value();
                continue;
            }
            return this.setUpParameter(operationGenerator, fieldAnnotation, genericType, defaultValue);
        }
        return null;
    }

    private Parameter setUpParameter(OperationGenerator operationGenerator, Annotation fieldAnnotation, Type genericParamType, String defaultValue) {
        AbstractSerializableParameter<?> parameter = this.createParameter(operationGenerator.getContext(), fieldAnnotation, genericParamType);
        if (null != defaultValue) {
            parameter.setDefaultValue(defaultValue);
        }
        return parameter;
    }

    private AbstractSerializableParameter<?> createParameter(SwaggerGeneratorContext swaggerGeneratorContext, Annotation fieldAnnotation, Type genericParamType) {
        AbstractParameterProcessor parameterAnnotationProcessor = (AbstractParameterProcessor)swaggerGeneratorContext.findParameterAnnotationProcessor(fieldAnnotation.annotationType());
        AbstractSerializableParameter parameter = parameterAnnotationProcessor.createParameter();
        String paramName = parameterAnnotationProcessor.getAnnotationParameterName((Object)fieldAnnotation);
        parameter.setName(paramName);
        ParamUtils.setParameterType((Type)genericParamType, (AbstractSerializableParameter)parameter);
        return parameter;
    }

    private boolean fieldShouldIgnore(Field beanParamField) {
        for (Annotation annotation : beanParamField.getAnnotations()) {
            if (!(annotation instanceof JsonIgnore)) continue;
            return true;
        }
        return false;
    }

    static {
        SUPPORTED_PARAM_ANNOTATIONS.add(PathParam.class);
        SUPPORTED_PARAM_ANNOTATIONS.add(QueryParam.class);
        SUPPORTED_PARAM_ANNOTATIONS.add(HeaderParam.class);
        SUPPORTED_PARAM_ANNOTATIONS.add(CookieParam.class);
        SUPPORTED_PARAM_ANNOTATIONS.add(FormParam.class);
    }
}

