/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.collapser;

import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.command.BatchHystrixCommand;
import com.netflix.hystrix.contrib.javanica.command.HystrixCommandBuilderFactory;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import java.util.Collection;
import java.util.List;
import org.slf4j.helpers.MessageFormatter;

public class CommandCollapser
extends HystrixCollapser<List<Object>, Object, Object> {
    private MetaHolder metaHolder;
    private static final String ERROR_MSG = "Failed to map all collapsed requests to response. The expected contract has not been respected. ";
    private static final String ERROR_MSF_TEMPLATE = "Collapser key: '{}', requests size: '{}', response size: '{}'";

    public CommandCollapser(MetaHolder metaHolder) {
        super(HystrixCommandBuilderFactory.getInstance().create(metaHolder).getSetterBuilder().buildCollapserCommandSetter());
        this.metaHolder = metaHolder;
    }

    public Object getRequestArgument() {
        return this.metaHolder.getArgs();
    }

    protected HystrixCommand<List<Object>> createCommand(Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests) {
        return new BatchHystrixCommand(HystrixCommandBuilderFactory.getInstance().create(this.metaHolder, collapsedRequests));
    }

    protected void mapResponseToRequests(List<Object> batchResponse, Collection<HystrixCollapser.CollapsedRequest<Object, Object>> collapsedRequests) {
        if (batchResponse.size() < collapsedRequests.size()) {
            throw new RuntimeException(this.createMessage(collapsedRequests, batchResponse));
        }
        int count = 0;
        for (HystrixCollapser.CollapsedRequest<Object, Object> request : collapsedRequests) {
            request.setResponse(batchResponse.get(count++));
        }
    }

    private String createMessage(Collection<HystrixCollapser.CollapsedRequest<Object, Object>> requests, List<Object> response) {
        return ERROR_MSG + MessageFormatter.arrayFormat((String)ERROR_MSF_TEMPLATE, (Object[])new Object[]{this.getCollapserKey().name(), requests.size(), response.size()}).getMessage();
    }
}

