/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.cache;

import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixRequestCache;
import com.netflix.hystrix.contrib.javanica.cache.CacheInvocationContext;
import com.netflix.hystrix.contrib.javanica.cache.HystrixCacheKeyGenerator;
import com.netflix.hystrix.contrib.javanica.cache.HystrixGeneratedCacheKey;
import com.netflix.hystrix.contrib.javanica.cache.annotation.CacheRemove;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategyDefault;

public final class HystrixRequestCacheManager {
    private static final HystrixRequestCacheManager INSTANCE = new HystrixRequestCacheManager();

    private HystrixRequestCacheManager() {
    }

    public static HystrixRequestCacheManager getInstance() {
        return INSTANCE;
    }

    public void clearCache(CacheInvocationContext<CacheRemove> context) {
        HystrixCacheKeyGenerator defaultCacheKeyGenerator = HystrixCacheKeyGenerator.getInstance();
        String cacheName = context.getCacheAnnotation().commandKey();
        HystrixGeneratedCacheKey hystrixGeneratedCacheKey = defaultCacheKeyGenerator.generateCacheKey(context);
        String key = hystrixGeneratedCacheKey.getCacheKey();
        HystrixRequestCache.getInstance((HystrixCommandKey)HystrixCommandKey.Factory.asKey((String)cacheName), (HystrixConcurrencyStrategy)HystrixConcurrencyStrategyDefault.getInstance()).clear(key);
    }
}

