/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.web.reactive.resource.ResourceTransformer;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class CachingResourceTransformer
implements ResourceTransformer {
    private static final Log logger = LogFactory.getLog(CachingResourceTransformer.class);
    private final Cache cache;

    public CachingResourceTransformer(Cache cache) {
        Assert.notNull((Object)cache, (String)"Cache is required");
        this.cache = cache;
    }

    public CachingResourceTransformer(CacheManager cacheManager, String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("Cache '" + cacheName + "' not found");
        }
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    @Override
    public Mono<Resource> transform(ServerWebExchange exchange, Resource resource, ResourceTransformerChain transformerChain) {
        Resource cachedResource = (Resource)this.cache.get((Object)resource, Resource.class);
        if (cachedResource != null) {
            logger.trace((Object)(exchange.getLogPrefix() + "Resource resolved from cache"));
            return Mono.just((Object)cachedResource);
        }
        return transformerChain.transform(exchange, resource).doOnNext(transformed -> this.cache.put((Object)resource, transformed));
    }
}

