/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.exporter.otlp.metrics;

import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.InstrumentType;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.export.MetricExporter;

@ThreadSafe
public final class OtlpGrpcMetricExporter
implements MetricExporter {
    private final GrpcExporter<MetricsRequestMarshaler> delegate;
    private final AggregationTemporalitySelector aggregationTemporalitySelector;

    public static OtlpGrpcMetricExporter getDefault() {
        return OtlpGrpcMetricExporter.builder().build();
    }

    public static OtlpGrpcMetricExporterBuilder builder() {
        return new OtlpGrpcMetricExporterBuilder();
    }

    OtlpGrpcMetricExporter(GrpcExporter<MetricsRequestMarshaler> delegate, AggregationTemporalitySelector aggregationTemporalitySelector) {
        this.delegate = delegate;
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
    }

    @Override
    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporalitySelector.getAggregationTemporality(instrumentType);
    }

    @Override
    public CompletableResultCode export(Collection<MetricData> metrics) {
        MetricsRequestMarshaler request = MetricsRequestMarshaler.create(metrics);
        return this.delegate.export(request, metrics.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }
}

