/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.recovery;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class VerifyIndex
implements PlainJsonSerializable {
    @Nullable
    private final Time checkIndexTime;
    private final String checkIndexTimeInMillis;
    @Nullable
    private final Time totalTime;
    private final String totalTimeInMillis;
    public static final JsonpDeserializer<VerifyIndex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, VerifyIndex::setupVerifyIndexDeserializer);

    private VerifyIndex(Builder builder) {
        this.checkIndexTime = builder.checkIndexTime;
        this.checkIndexTimeInMillis = ApiTypeHelper.requireNonNull(builder.checkIndexTimeInMillis, this, "checkIndexTimeInMillis");
        this.totalTime = builder.totalTime;
        this.totalTimeInMillis = ApiTypeHelper.requireNonNull(builder.totalTimeInMillis, this, "totalTimeInMillis");
    }

    public static VerifyIndex of(Function<Builder, ObjectBuilder<VerifyIndex>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time checkIndexTime() {
        return this.checkIndexTime;
    }

    public final String checkIndexTimeInMillis() {
        return this.checkIndexTimeInMillis;
    }

    @Nullable
    public final Time totalTime() {
        return this.totalTime;
    }

    public final String totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.checkIndexTime != null) {
            generator.writeKey("check_index_time");
            this.checkIndexTime.serialize(generator, mapper);
        }
        generator.writeKey("check_index_time_in_millis");
        generator.write(this.checkIndexTimeInMillis);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            this.totalTime.serialize(generator, mapper);
        }
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
    }

    protected static void setupVerifyIndexDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::checkIndexTime, Time._DESERIALIZER, "check_index_time");
        op.add(Builder::checkIndexTimeInMillis, JsonpDeserializer.stringDeserializer(), "check_index_time_in_millis");
        op.add(Builder::totalTime, Time._DESERIALIZER, "total_time");
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.stringDeserializer(), "total_time_in_millis");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<VerifyIndex> {
        @Nullable
        private Time checkIndexTime;
        private String checkIndexTimeInMillis;
        @Nullable
        private Time totalTime;
        private String totalTimeInMillis;

        public final Builder checkIndexTime(@Nullable Time value) {
            this.checkIndexTime = value;
            return this;
        }

        public final Builder checkIndexTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.checkIndexTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder checkIndexTimeInMillis(String value) {
            this.checkIndexTimeInMillis = value;
            return this;
        }

        public final Builder totalTime(@Nullable Time value) {
            this.totalTime = value;
            return this;
        }

        public final Builder totalTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.totalTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder totalTimeInMillis(String value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Override
        public VerifyIndex build() {
            this._checkSingleUse();
            return new VerifyIndex(this);
        }
    }
}

