/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.aes;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import com.google.common.io.FileBackedOutputStream;
import com.google.crypto.tink.subtle.AesGcmHkdfStreaming;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.blob.aes.CryptoConfig;
import org.apache.james.blob.aes.PBKDF2StreamingAeadFactory;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.ObjectNotFoundException;
import org.apache.james.blob.api.ObjectStoreIOException;
import org.apache.james.util.Size;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class AESBlobStoreDAO
implements BlobStoreDAO {
    public static final int FILE_THRESHOLD_ENCRYPT = Optional.ofNullable(System.getProperty("james.blob.aes.file.threshold.encrypt")).map(s -> Size.parse((String)s, (Size.Unit)Size.Unit.NoUnit)).map(s -> (int)s.asBytes()).orElse(102400);
    public static final int MAXIMUM_BLOB_SIZE = Optional.ofNullable(System.getProperty("james.blob.aes.blob.max.size")).map(s -> Size.parse((String)s, (Size.Unit)Size.Unit.NoUnit)).map(s -> (int)s.asBytes()).orElse(0x6400000);
    private final BlobStoreDAO underlying;
    private final AesGcmHkdfStreaming streamingAead;

    public AESBlobStoreDAO(BlobStoreDAO underlying, CryptoConfig cryptoConfig) {
        this.underlying = underlying;
        this.streamingAead = PBKDF2StreamingAeadFactory.newAesGcmHkdfStreaming(cryptoConfig);
    }

    private Pair<FileBackedOutputStream, Long> encrypt(InputStream input) throws IOException {
        try (FileBackedOutputStream encryptedContent = new FileBackedOutputStream(FILE_THRESHOLD_ENCRYPT);){
            Pair pair;
            CountingOutputStream countingOutputStream = new CountingOutputStream((OutputStream)encryptedContent);
            try {
                OutputStream outputStream = this.streamingAead.newEncryptingStream((OutputStream)countingOutputStream, PBKDF2StreamingAeadFactory.EMPTY_ASSOCIATED_DATA);
                input.transferTo(outputStream);
                outputStream.close();
                pair = Pair.of((Object)encryptedContent, (Object)countingOutputStream.getCount());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        countingOutputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    encryptedContent.reset();
                    throw new RuntimeException("Unable to build payload for object storage, failed to encrypt", e);
                }
            }
            countingOutputStream.close();
            return pair;
        }
    }

    public InputStream decrypt(InputStream ciphertext) throws IOException {
        try {
            return ByteStreams.limit((InputStream)this.streamingAead.newDecryptingStream(ciphertext, PBKDF2StreamingAeadFactory.EMPTY_ASSOCIATED_DATA), (long)MAXIMUM_BLOB_SIZE);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Incorrect crypto setup", e);
        }
    }

    public InputStream read(BucketName bucketName, BlobId blobId) throws ObjectStoreIOException, ObjectNotFoundException {
        try {
            return this.decrypt(this.underlying.read(bucketName, blobId));
        }
        catch (IOException e) {
            throw new ObjectStoreIOException("Error reading blob " + blobId.asString(), (Throwable)e);
        }
    }

    public Publisher<InputStream> readReactive(BucketName bucketName, BlobId blobId) {
        return Mono.from((Publisher)this.underlying.readReactive(bucketName, blobId)).map((Function)Throwing.function(this::decrypt));
    }

    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        return Mono.from((Publisher)this.underlying.readBytes(bucketName, blobId)).map((Function)Throwing.function(bytes -> {
            InputStream inputStream = this.decrypt(new ByteArrayInputStream((byte[])bytes));
            try (UnsynchronizedByteArrayOutputStream outputStream = ((UnsynchronizedByteArrayOutputStream.Builder)UnsynchronizedByteArrayOutputStream.builder().setBufferSize(((byte[])bytes).length + 4096)).get();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                byte[] byArray = outputStream.toByteArray();
                return byArray;
            }
        }));
    }

    public Publisher<Void> save(BucketName bucketName, BlobId blobId, byte[] data) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)blobId);
        Preconditions.checkNotNull((Object)data);
        return this.save(bucketName, blobId, new ByteArrayInputStream(data));
    }

    public Publisher<Void> save(BucketName bucketName, BlobId blobId, InputStream inputStream) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)blobId);
        Preconditions.checkNotNull((Object)inputStream);
        return Mono.usingWhen((Publisher)Mono.fromCallable(() -> this.encrypt(inputStream)), pair -> Mono.from((Publisher)this.underlying.save(bucketName, blobId, this.byteSourceWithSize(((FileBackedOutputStream)pair.getLeft()).asByteSource(), (Long)pair.getRight()))), (Function)Throwing.function(pair -> Mono.fromRunnable((Runnable)Throwing.runnable(() -> ((FileBackedOutputStream)((FileBackedOutputStream)pair.getLeft())).reset())).subscribeOn(Schedulers.boundedElastic()))).subscribeOn(Schedulers.boundedElastic()).onErrorMap(e -> new ObjectStoreIOException("Exception occurred while saving bytearray", e));
    }

    private ByteSource byteSourceWithSize(final ByteSource byteSource, final long size) {
        return new ByteSource(this){

            public InputStream openStream() throws IOException {
                return byteSource.openStream();
            }

            public com.google.common.base.Optional<Long> sizeIfKnown() {
                return com.google.common.base.Optional.of((Object)size);
            }

            public long size() {
                return size;
            }
        };
    }

    public Publisher<Void> save(BucketName bucketName, BlobId blobId, ByteSource content) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)blobId);
        Preconditions.checkNotNull((Object)content);
        return Mono.using(() -> ((ByteSource)content).openStream(), in -> Mono.from(this.save(bucketName, blobId, (InputStream)in)), (Consumer)Throwing.consumer(InputStream::close)).subscribeOn(Schedulers.boundedElastic());
    }

    public Publisher<Void> delete(BucketName bucketName, BlobId blobId) {
        return this.underlying.delete(bucketName, blobId);
    }

    public Publisher<Void> delete(BucketName bucketName, Collection<BlobId> blobIds) {
        return this.underlying.delete(bucketName, blobIds);
    }

    public Publisher<Void> deleteBucket(BucketName bucketName) {
        return this.underlying.deleteBucket(bucketName);
    }

    public Publisher<BucketName> listBuckets() {
        return this.underlying.listBuckets();
    }

    public Publisher<BlobId> listBlobs(BucketName bucketName) {
        return this.underlying.listBlobs(bucketName);
    }
}

