/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import org.apache.pulsar.common.api.proto.AuthMethod;
import org.apache.pulsar.common.api.proto.FeatureFlags;
import org.apache.pulsar.common.api.proto.LightProtoCodec;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;

public final class CommandConnect {
    private String clientVersion;
    private int _clientVersionBufferIdx = -1;
    private int _clientVersionBufferLen = -1;
    private static final int _CLIENT_VERSION_FIELD_NUMBER = 1;
    private static final int _CLIENT_VERSION_TAG = 10;
    private static final int _CLIENT_VERSION_TAG_SIZE = LightProtoCodec.computeVarIntSize(10);
    private static final int _CLIENT_VERSION_MASK = 1;
    private AuthMethod authMethod;
    private static final int _AUTH_METHOD_FIELD_NUMBER = 2;
    private static final int _AUTH_METHOD_TAG = 16;
    private static final int _AUTH_METHOD_TAG_SIZE = LightProtoCodec.computeVarIntSize(16);
    private static final int _AUTH_METHOD_MASK = 2;
    private ByteBuf authData = null;
    private int _authDataIdx = -1;
    private int _authDataLen = -1;
    private static final int _AUTH_DATA_FIELD_NUMBER = 3;
    private static final int _AUTH_DATA_TAG = 26;
    private static final int _AUTH_DATA_TAG_SIZE = LightProtoCodec.computeVarIntSize(26);
    private static final int _AUTH_DATA_MASK = 4;
    private int protocolVersion = 0;
    private static final int _PROTOCOL_VERSION_FIELD_NUMBER = 4;
    private static final int _PROTOCOL_VERSION_TAG = 32;
    private static final int _PROTOCOL_VERSION_TAG_SIZE = LightProtoCodec.computeVarIntSize(32);
    private static final int _PROTOCOL_VERSION_MASK = 8;
    private String authMethodName;
    private int _authMethodNameBufferIdx = -1;
    private int _authMethodNameBufferLen = -1;
    private static final int _AUTH_METHOD_NAME_FIELD_NUMBER = 5;
    private static final int _AUTH_METHOD_NAME_TAG = 42;
    private static final int _AUTH_METHOD_NAME_TAG_SIZE = LightProtoCodec.computeVarIntSize(42);
    private static final int _AUTH_METHOD_NAME_MASK = 16;
    private String proxyToBrokerUrl;
    private int _proxyToBrokerUrlBufferIdx = -1;
    private int _proxyToBrokerUrlBufferLen = -1;
    private static final int _PROXY_TO_BROKER_URL_FIELD_NUMBER = 6;
    private static final int _PROXY_TO_BROKER_URL_TAG = 50;
    private static final int _PROXY_TO_BROKER_URL_TAG_SIZE = LightProtoCodec.computeVarIntSize(50);
    private static final int _PROXY_TO_BROKER_URL_MASK = 32;
    private String originalPrincipal;
    private int _originalPrincipalBufferIdx = -1;
    private int _originalPrincipalBufferLen = -1;
    private static final int _ORIGINAL_PRINCIPAL_FIELD_NUMBER = 7;
    private static final int _ORIGINAL_PRINCIPAL_TAG = 58;
    private static final int _ORIGINAL_PRINCIPAL_TAG_SIZE = LightProtoCodec.computeVarIntSize(58);
    private static final int _ORIGINAL_PRINCIPAL_MASK = 64;
    private String originalAuthData;
    private int _originalAuthDataBufferIdx = -1;
    private int _originalAuthDataBufferLen = -1;
    private static final int _ORIGINAL_AUTH_DATA_FIELD_NUMBER = 8;
    private static final int _ORIGINAL_AUTH_DATA_TAG = 66;
    private static final int _ORIGINAL_AUTH_DATA_TAG_SIZE = LightProtoCodec.computeVarIntSize(66);
    private static final int _ORIGINAL_AUTH_DATA_MASK = 128;
    private String originalAuthMethod;
    private int _originalAuthMethodBufferIdx = -1;
    private int _originalAuthMethodBufferLen = -1;
    private static final int _ORIGINAL_AUTH_METHOD_FIELD_NUMBER = 9;
    private static final int _ORIGINAL_AUTH_METHOD_TAG = 74;
    private static final int _ORIGINAL_AUTH_METHOD_TAG_SIZE = LightProtoCodec.computeVarIntSize(74);
    private static final int _ORIGINAL_AUTH_METHOD_MASK = 256;
    private FeatureFlags featureFlags;
    private static final int _FEATURE_FLAGS_FIELD_NUMBER = 10;
    private static final int _FEATURE_FLAGS_TAG = 82;
    private static final int _FEATURE_FLAGS_TAG_SIZE = LightProtoCodec.computeVarIntSize(82);
    private static final int _FEATURE_FLAGS_MASK = 512;
    private String proxyVersion;
    private int _proxyVersionBufferIdx = -1;
    private int _proxyVersionBufferLen = -1;
    private static final int _PROXY_VERSION_FIELD_NUMBER = 11;
    private static final int _PROXY_VERSION_TAG = 90;
    private static final int _PROXY_VERSION_TAG_SIZE = LightProtoCodec.computeVarIntSize(90);
    private static final int _PROXY_VERSION_MASK = 1024;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 1;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasClientVersion() {
        return (this._bitField0 & 1) != 0;
    }

    public String getClientVersion() {
        if (!this.hasClientVersion()) {
            throw new IllegalStateException("Field 'client_version' is not set");
        }
        if (this.clientVersion == null) {
            this.clientVersion = LightProtoCodec.readString(this._parsedBuffer, this._clientVersionBufferIdx, this._clientVersionBufferLen);
        }
        return this.clientVersion;
    }

    public CommandConnect setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
        this._bitField0 |= 1;
        this._clientVersionBufferIdx = -1;
        this._clientVersionBufferLen = LightProtoCodec.computeStringUTF8Size(clientVersion);
        this._cachedSize = -1;
        return this;
    }

    public CommandConnect clearClientVersion() {
        this._bitField0 &= 0xFFFFFFFE;
        this.clientVersion = null;
        this._clientVersionBufferIdx = -1;
        this._clientVersionBufferLen = -1;
        return this;
    }

    public boolean hasAuthMethod() {
        return (this._bitField0 & 2) != 0;
    }

    public AuthMethod getAuthMethod() {
        if (!this.hasAuthMethod()) {
            throw new IllegalStateException("Field 'auth_method' is not set");
        }
        return this.authMethod;
    }

    public CommandConnect setAuthMethod(AuthMethod authMethod) {
        this.authMethod = authMethod;
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this;
    }

    public CommandConnect clearAuthMethod() {
        this._bitField0 &= 0xFFFFFFFD;
        return this;
    }

    public boolean hasAuthData() {
        return (this._bitField0 & 4) != 0;
    }

    public int getAuthDataSize() {
        if (!this.hasAuthData()) {
            throw new IllegalStateException("Field 'auth_data' is not set");
        }
        return this._authDataLen;
    }

    public byte[] getAuthData() {
        ByteBuf _b = this.getAuthDataSlice();
        byte[] res = new byte[_b.readableBytes()];
        _b.getBytes(0, res);
        return res;
    }

    public ByteBuf getAuthDataSlice() {
        if (!this.hasAuthData()) {
            throw new IllegalStateException("Field 'auth_data' is not set");
        }
        if (this.authData == null) {
            return this._parsedBuffer.slice(this._authDataIdx, this._authDataLen);
        }
        return this.authData.slice(0, this._authDataLen);
    }

    public CommandConnect setAuthData(byte[] authData) {
        this.setAuthData(Unpooled.wrappedBuffer(authData));
        return this;
    }

    public CommandConnect setAuthData(ByteBuf authData) {
        this.authData = authData;
        this._bitField0 |= 4;
        this._authDataIdx = -1;
        this._authDataLen = authData.readableBytes();
        this._cachedSize = -1;
        return this;
    }

    public CommandConnect clearAuthData() {
        this._bitField0 &= 0xFFFFFFFB;
        this.authData = null;
        this._authDataIdx = -1;
        this._authDataLen = -1;
        return this;
    }

    public boolean hasProtocolVersion() {
        return (this._bitField0 & 8) != 0;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public CommandConnect setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
        this._bitField0 |= 8;
        this._cachedSize = -1;
        return this;
    }

    public CommandConnect clearProtocolVersion() {
        this._bitField0 &= 0xFFFFFFF7;
        this.protocolVersion = 0;
        return this;
    }

    public boolean hasAuthMethodName() {
        return (this._bitField0 & 0x10) != 0;
    }

    public String getAuthMethodName() {
        if (!this.hasAuthMethodName()) {
            throw new IllegalStateException("Field 'auth_method_name' is not set");
        }
        if (this.authMethodName == null) {
            this.authMethodName = LightProtoCodec.readString(this._parsedBuffer, this._authMethodNameBufferIdx, this._authMethodNameBufferLen);
        }
        return this.authMethodName;
    }

    public CommandConnect setAuthMethodName(String authMethodName) {
        this.authMethodName = authMethodName;
        this._bitField0 |= 0x10;
        this._authMethodNameBufferIdx = -1;
        this._authMethodNameBufferLen = LightProtoCodec.computeStringUTF8Size(authMethodName);
        this._cachedSize = -1;
        return this;
    }

    public CommandConnect clearAuthMethodName() {
        this._bitField0 &= 0xFFFFFFEF;
        this.authMethodName = null;
        this._authMethodNameBufferIdx = -1;
        this._authMethodNameBufferLen = -1;
        return this;
    }

    public boolean hasProxyToBrokerUrl() {
        return (this._bitField0 & 0x20) != 0;
    }

    public String getProxyToBrokerUrl() {
        if (!this.hasProxyToBrokerUrl()) {
            throw new IllegalStateException("Field 'proxy_to_broker_url' is not set");
        }
        if (this.proxyToBrokerUrl == null) {
            this.proxyToBrokerUrl = LightProtoCodec.readString(this._parsedBuffer, this._proxyToBrokerUrlBufferIdx, this._proxyToBrokerUrlBufferLen);
        }
        return this.proxyToBrokerUrl;
    }

    public CommandConnect setProxyToBrokerUrl(String proxyToBrokerUrl) {
        this.proxyToBrokerUrl = proxyToBrokerUrl;
        this._bitField0 |= 0x20;
        this._proxyToBrokerUrlBufferIdx = -1;
        this._proxyToBrokerUrlBufferLen = LightProtoCodec.computeStringUTF8Size(proxyToBrokerUrl);
        this._cachedSize = -1;
        return this;
    }

    public CommandConnect clearProxyToBrokerUrl() {
        this._bitField0 &= 0xFFFFFFDF;
        this.proxyToBrokerUrl = null;
        this._proxyToBrokerUrlBufferIdx = -1;
        this._proxyToBrokerUrlBufferLen = -1;
        return this;
    }

    public boolean hasOriginalPrincipal() {
        return (this._bitField0 & 0x40) != 0;
    }

    public String getOriginalPrincipal() {
        if (!this.hasOriginalPrincipal()) {
            throw new IllegalStateException("Field 'original_principal' is not set");
        }
        if (this.originalPrincipal == null) {
            this.originalPrincipal = LightProtoCodec.readString(this._parsedBuffer, this._originalPrincipalBufferIdx, this._originalPrincipalBufferLen);
        }
        return this.originalPrincipal;
    }

    public CommandConnect setOriginalPrincipal(String originalPrincipal) {
        this.originalPrincipal = originalPrincipal;
        this._bitField0 |= 0x40;
        this._originalPrincipalBufferIdx = -1;
        this._originalPrincipalBufferLen = LightProtoCodec.computeStringUTF8Size(originalPrincipal);
        this._cachedSize = -1;
        return this;
    }

    public CommandConnect clearOriginalPrincipal() {
        this._bitField0 &= 0xFFFFFFBF;
        this.originalPrincipal = null;
        this._originalPrincipalBufferIdx = -1;
        this._originalPrincipalBufferLen = -1;
        return this;
    }

    public boolean hasOriginalAuthData() {
        return (this._bitField0 & 0x80) != 0;
    }

    public String getOriginalAuthData() {
        if (!this.hasOriginalAuthData()) {
            throw new IllegalStateException("Field 'original_auth_data' is not set");
        }
        if (this.originalAuthData == null) {
            this.originalAuthData = LightProtoCodec.readString(this._parsedBuffer, this._originalAuthDataBufferIdx, this._originalAuthDataBufferLen);
        }
        return this.originalAuthData;
    }

    public CommandConnect setOriginalAuthData(String originalAuthData) {
        this.originalAuthData = originalAuthData;
        this._bitField0 |= 0x80;
        this._originalAuthDataBufferIdx = -1;
        this._originalAuthDataBufferLen = LightProtoCodec.computeStringUTF8Size(originalAuthData);
        this._cachedSize = -1;
        return this;
    }

    public CommandConnect clearOriginalAuthData() {
        this._bitField0 &= 0xFFFFFF7F;
        this.originalAuthData = null;
        this._originalAuthDataBufferIdx = -1;
        this._originalAuthDataBufferLen = -1;
        return this;
    }

    public boolean hasOriginalAuthMethod() {
        return (this._bitField0 & 0x100) != 0;
    }

    public String getOriginalAuthMethod() {
        if (!this.hasOriginalAuthMethod()) {
            throw new IllegalStateException("Field 'original_auth_method' is not set");
        }
        if (this.originalAuthMethod == null) {
            this.originalAuthMethod = LightProtoCodec.readString(this._parsedBuffer, this._originalAuthMethodBufferIdx, this._originalAuthMethodBufferLen);
        }
        return this.originalAuthMethod;
    }

    public CommandConnect setOriginalAuthMethod(String originalAuthMethod) {
        this.originalAuthMethod = originalAuthMethod;
        this._bitField0 |= 0x100;
        this._originalAuthMethodBufferIdx = -1;
        this._originalAuthMethodBufferLen = LightProtoCodec.computeStringUTF8Size(originalAuthMethod);
        this._cachedSize = -1;
        return this;
    }

    public CommandConnect clearOriginalAuthMethod() {
        this._bitField0 &= 0xFFFFFEFF;
        this.originalAuthMethod = null;
        this._originalAuthMethodBufferIdx = -1;
        this._originalAuthMethodBufferLen = -1;
        return this;
    }

    public boolean hasFeatureFlags() {
        return (this._bitField0 & 0x200) != 0;
    }

    public FeatureFlags getFeatureFlags() {
        if (!this.hasFeatureFlags()) {
            throw new IllegalStateException("Field 'feature_flags' is not set");
        }
        return this.featureFlags;
    }

    public FeatureFlags setFeatureFlags() {
        if (this.featureFlags == null) {
            this.featureFlags = new FeatureFlags();
        }
        this._bitField0 |= 0x200;
        this._cachedSize = -1;
        return this.featureFlags;
    }

    public CommandConnect clearFeatureFlags() {
        this._bitField0 &= 0xFFFFFDFF;
        if (this.hasFeatureFlags()) {
            this.featureFlags.clear();
        }
        return this;
    }

    public boolean hasProxyVersion() {
        return (this._bitField0 & 0x400) != 0;
    }

    public String getProxyVersion() {
        if (!this.hasProxyVersion()) {
            throw new IllegalStateException("Field 'proxy_version' is not set");
        }
        if (this.proxyVersion == null) {
            this.proxyVersion = LightProtoCodec.readString(this._parsedBuffer, this._proxyVersionBufferIdx, this._proxyVersionBufferLen);
        }
        return this.proxyVersion;
    }

    public CommandConnect setProxyVersion(String proxyVersion) {
        this.proxyVersion = proxyVersion;
        this._bitField0 |= 0x400;
        this._proxyVersionBufferIdx = -1;
        this._proxyVersionBufferLen = LightProtoCodec.computeStringUTF8Size(proxyVersion);
        this._cachedSize = -1;
        return this;
    }

    public CommandConnect clearProxyVersion() {
        this._bitField0 &= 0xFFFFFBFF;
        this.proxyVersion = null;
        this._proxyVersionBufferIdx = -1;
        this._proxyVersionBufferLen = -1;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 10);
        LightProtoCodec.writeVarInt(_b, this._clientVersionBufferLen);
        if (this._clientVersionBufferIdx == -1) {
            LightProtoCodec.writeString(_b, this.clientVersion, this._clientVersionBufferLen);
        } else {
            this._parsedBuffer.getBytes(this._clientVersionBufferIdx, _b, this._clientVersionBufferLen);
        }
        if (this.hasAuthMethod()) {
            LightProtoCodec.writeVarInt(_b, 16);
            LightProtoCodec.writeVarInt(_b, this.authMethod.getValue());
        }
        if (this.hasAuthData()) {
            LightProtoCodec.writeVarInt(_b, 26);
            LightProtoCodec.writeVarInt(_b, this._authDataLen);
            if (this._authDataIdx == -1) {
                _b.writeBytes(this.authData);
            } else {
                this._parsedBuffer.getBytes(this._authDataIdx, _b, this._authDataLen);
            }
        }
        if (this.hasProtocolVersion()) {
            LightProtoCodec.writeVarInt(_b, 32);
            LightProtoCodec.writeVarInt(_b, this.protocolVersion);
        }
        if (this.hasAuthMethodName()) {
            LightProtoCodec.writeVarInt(_b, 42);
            LightProtoCodec.writeVarInt(_b, this._authMethodNameBufferLen);
            if (this._authMethodNameBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.authMethodName, this._authMethodNameBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._authMethodNameBufferIdx, _b, this._authMethodNameBufferLen);
            }
        }
        if (this.hasProxyToBrokerUrl()) {
            LightProtoCodec.writeVarInt(_b, 50);
            LightProtoCodec.writeVarInt(_b, this._proxyToBrokerUrlBufferLen);
            if (this._proxyToBrokerUrlBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.proxyToBrokerUrl, this._proxyToBrokerUrlBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._proxyToBrokerUrlBufferIdx, _b, this._proxyToBrokerUrlBufferLen);
            }
        }
        if (this.hasOriginalPrincipal()) {
            LightProtoCodec.writeVarInt(_b, 58);
            LightProtoCodec.writeVarInt(_b, this._originalPrincipalBufferLen);
            if (this._originalPrincipalBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.originalPrincipal, this._originalPrincipalBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._originalPrincipalBufferIdx, _b, this._originalPrincipalBufferLen);
            }
        }
        if (this.hasOriginalAuthData()) {
            LightProtoCodec.writeVarInt(_b, 66);
            LightProtoCodec.writeVarInt(_b, this._originalAuthDataBufferLen);
            if (this._originalAuthDataBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.originalAuthData, this._originalAuthDataBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._originalAuthDataBufferIdx, _b, this._originalAuthDataBufferLen);
            }
        }
        if (this.hasOriginalAuthMethod()) {
            LightProtoCodec.writeVarInt(_b, 74);
            LightProtoCodec.writeVarInt(_b, this._originalAuthMethodBufferLen);
            if (this._originalAuthMethodBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.originalAuthMethod, this._originalAuthMethodBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._originalAuthMethodBufferIdx, _b, this._originalAuthMethodBufferLen);
            }
        }
        if (this.hasFeatureFlags()) {
            LightProtoCodec.writeVarInt(_b, 82);
            LightProtoCodec.writeVarInt(_b, this.featureFlags.getSerializedSize());
            this.featureFlags.writeTo(_b);
        }
        if (this.hasProxyVersion()) {
            LightProtoCodec.writeVarInt(_b, 90);
            LightProtoCodec.writeVarInt(_b, this._proxyVersionBufferLen);
            if (this._proxyVersionBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.proxyVersion, this._proxyVersionBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._proxyVersionBufferIdx, _b, this._proxyVersionBufferLen);
            }
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _CLIENT_VERSION_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this._clientVersionBufferLen);
        _size += this._clientVersionBufferLen;
        if (this.hasAuthMethod()) {
            _size += _AUTH_METHOD_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.authMethod.getValue());
        }
        if (this.hasAuthData()) {
            _size += _AUTH_DATA_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._authDataLen) + this._authDataLen;
        }
        if (this.hasProtocolVersion()) {
            _size += _PROTOCOL_VERSION_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.protocolVersion);
        }
        if (this.hasAuthMethodName()) {
            _size += _AUTH_METHOD_NAME_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._authMethodNameBufferLen);
            _size += this._authMethodNameBufferLen;
        }
        if (this.hasProxyToBrokerUrl()) {
            _size += _PROXY_TO_BROKER_URL_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._proxyToBrokerUrlBufferLen);
            _size += this._proxyToBrokerUrlBufferLen;
        }
        if (this.hasOriginalPrincipal()) {
            _size += _ORIGINAL_PRINCIPAL_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._originalPrincipalBufferLen);
            _size += this._originalPrincipalBufferLen;
        }
        if (this.hasOriginalAuthData()) {
            _size += _ORIGINAL_AUTH_DATA_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._originalAuthDataBufferLen);
            _size += this._originalAuthDataBufferLen;
        }
        if (this.hasOriginalAuthMethod()) {
            _size += _ORIGINAL_AUTH_METHOD_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._originalAuthMethodBufferLen);
            _size += this._originalAuthMethodBufferLen;
        }
        if (this.hasFeatureFlags()) {
            _size += LightProtoCodec.computeVarIntSize(82);
            int MsgsizeFeatureFlags = this.featureFlags.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeFeatureFlags) + MsgsizeFeatureFlags;
        }
        if (this.hasProxyVersion()) {
            _size += _PROXY_VERSION_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._proxyVersionBufferLen);
            _size += this._proxyVersionBufferLen;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block13: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 10: {
                    this._bitField0 |= 1;
                    this._clientVersionBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._clientVersionBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._clientVersionBufferLen);
                    continue block13;
                }
                case 16: {
                    AuthMethod _authMethod = AuthMethod.valueOf(LightProtoCodec.readVarInt(_buffer));
                    if (_authMethod == null) continue block13;
                    this._bitField0 |= 2;
                    this.authMethod = _authMethod;
                    continue block13;
                }
                case 26: {
                    this._bitField0 |= 4;
                    this._authDataLen = LightProtoCodec.readVarInt(_buffer);
                    this._authDataIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._authDataLen);
                    continue block13;
                }
                case 32: {
                    this._bitField0 |= 8;
                    this.protocolVersion = LightProtoCodec.readVarInt(_buffer);
                    continue block13;
                }
                case 42: {
                    this._bitField0 |= 0x10;
                    this._authMethodNameBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._authMethodNameBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._authMethodNameBufferLen);
                    continue block13;
                }
                case 50: {
                    this._bitField0 |= 0x20;
                    this._proxyToBrokerUrlBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._proxyToBrokerUrlBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._proxyToBrokerUrlBufferLen);
                    continue block13;
                }
                case 58: {
                    this._bitField0 |= 0x40;
                    this._originalPrincipalBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._originalPrincipalBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._originalPrincipalBufferLen);
                    continue block13;
                }
                case 66: {
                    this._bitField0 |= 0x80;
                    this._originalAuthDataBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._originalAuthDataBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._originalAuthDataBufferLen);
                    continue block13;
                }
                case 74: {
                    this._bitField0 |= 0x100;
                    this._originalAuthMethodBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._originalAuthMethodBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._originalAuthMethodBufferLen);
                    continue block13;
                }
                case 82: {
                    this._bitField0 |= 0x200;
                    int featureFlagsSize = LightProtoCodec.readVarInt(_buffer);
                    this.setFeatureFlags().parseFrom(_buffer, featureFlagsSize);
                    continue block13;
                }
                case 90: {
                    this._bitField0 |= 0x400;
                    this._proxyVersionBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._proxyVersionBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._proxyVersionBufferLen);
                    continue block13;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 1) != 1) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public CommandConnect clear() {
        this.clientVersion = null;
        this._clientVersionBufferIdx = -1;
        this._clientVersionBufferLen = -1;
        this.authData = null;
        this._authDataIdx = -1;
        this._authDataLen = -1;
        this.protocolVersion = 0;
        this.authMethodName = null;
        this._authMethodNameBufferIdx = -1;
        this._authMethodNameBufferLen = -1;
        this.proxyToBrokerUrl = null;
        this._proxyToBrokerUrlBufferIdx = -1;
        this._proxyToBrokerUrlBufferLen = -1;
        this.originalPrincipal = null;
        this._originalPrincipalBufferIdx = -1;
        this._originalPrincipalBufferLen = -1;
        this.originalAuthData = null;
        this._originalAuthDataBufferIdx = -1;
        this._originalAuthDataBufferLen = -1;
        this.originalAuthMethod = null;
        this._originalAuthMethodBufferIdx = -1;
        this._originalAuthMethodBufferLen = -1;
        if (this.hasFeatureFlags()) {
            this.featureFlags.clear();
        }
        this.proxyVersion = null;
        this._proxyVersionBufferIdx = -1;
        this._proxyVersionBufferLen = -1;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public CommandConnect copyFrom(CommandConnect _other) {
        this._cachedSize = -1;
        if (_other.hasClientVersion()) {
            this.setClientVersion(_other.getClientVersion());
        }
        if (_other.hasAuthMethod()) {
            this.setAuthMethod(_other.authMethod);
        }
        if (_other.hasAuthData()) {
            this.setAuthData(_other.getAuthData());
        }
        if (_other.hasProtocolVersion()) {
            this.setProtocolVersion(_other.protocolVersion);
        }
        if (_other.hasAuthMethodName()) {
            this.setAuthMethodName(_other.getAuthMethodName());
        }
        if (_other.hasProxyToBrokerUrl()) {
            this.setProxyToBrokerUrl(_other.getProxyToBrokerUrl());
        }
        if (_other.hasOriginalPrincipal()) {
            this.setOriginalPrincipal(_other.getOriginalPrincipal());
        }
        if (_other.hasOriginalAuthData()) {
            this.setOriginalAuthData(_other.getOriginalAuthData());
        }
        if (_other.hasOriginalAuthMethod()) {
            this.setOriginalAuthMethod(_other.getOriginalAuthMethod());
        }
        if (_other.hasFeatureFlags()) {
            this.setFeatureFlags().copyFrom(_other.featureFlags);
        }
        if (_other.hasProxyVersion()) {
            this.setProxyVersion(_other.getProxyVersion());
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

