/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.store.mail.model.MimeMessageId;
import org.apache.james.mailbox.store.mail.model.Subject;
import reactor.core.publisher.Flux;

public class CassandraThreadDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insertOne;
    private final PreparedStatement selectOne;
    private final PreparedStatement deleteOne;

    @Inject
    public CassandraThreadDAO(Session session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insertOne = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"threadTable").value("username", (Object)QueryBuilder.bindMarker((String)"username")).value("mimeMessageId", (Object)QueryBuilder.bindMarker((String)"mimeMessageId")).value("messageId", (Object)QueryBuilder.bindMarker((String)"messageId")).value("threadId", (Object)QueryBuilder.bindMarker((String)"threadId")).value("baseSubject", (Object)QueryBuilder.bindMarker((String)"baseSubject")));
        this.selectOne = session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"baseSubject", "threadId"}).from("threadTable").where(QueryBuilder.eq((String)"username", (Object)QueryBuilder.bindMarker((String)"username"))).and(QueryBuilder.eq((String)"mimeMessageId", (Object)QueryBuilder.bindMarker((String)"mimeMessageId"))));
        this.deleteOne = session.prepare((RegularStatement)QueryBuilder.delete().from("threadTable").where(QueryBuilder.eq((String)"username", (Object)QueryBuilder.bindMarker((String)"username"))).and(QueryBuilder.eq((String)"mimeMessageId", (Object)QueryBuilder.bindMarker((String)"mimeMessageId"))));
    }

    public Flux<Void> insertSome(Username username, Set<MimeMessageId> mimeMessageIds, MessageId messageId, ThreadId threadId, Optional<Subject> baseSubject) {
        return Flux.fromIterable(mimeMessageIds).flatMap(mimeMessageId -> this.executor.executeVoid((Statement)this.insertOne.bind().setString("username", username.asString()).setString("mimeMessageId", mimeMessageId.getValue()).setUUID("messageId", ((CassandraMessageId)messageId).get()).setUUID("threadId", ((CassandraMessageId)threadId.getBaseMessageId()).get()).setString("baseSubject", (String)baseSubject.map(Subject::getValue).orElse(null))), 16);
    }

    public Flux<Pair<Optional<Subject>, ThreadId>> selectSome(Username username, Set<MimeMessageId> mimeMessageIds) {
        return Flux.fromIterable(mimeMessageIds).flatMap(mimeMessageId -> this.executor.executeSingleRow((Statement)this.selectOne.bind().setString("username", username.asString()).setString("mimeMessageId", mimeMessageId.getValue())).map(this::readRow), 16).distinct();
    }

    public Flux<Void> deleteSome(Username username, Set<MimeMessageId> mimeMessageIds) {
        return Flux.fromIterable(mimeMessageIds).flatMap(mimeMessageId -> this.executor.executeVoid((Statement)this.deleteOne.bind().setString("username", username.asString()).setString("mimeMessageId", mimeMessageId.getValue())));
    }

    public Pair<Optional<Subject>, ThreadId> readRow(Row row) {
        return Pair.of(Optional.ofNullable(row.getString("baseSubject")).map(Subject::new), (Object)ThreadId.fromBaseMessageId((MessageId)CassandraMessageId.Factory.of(row.getUUID("threadId"))));
    }
}

