/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra;

import com.datastax.driver.core.Session;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.utils.CassandraUtils;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.cassandra.DeleteMessageListener;
import org.apache.james.mailbox.cassandra.mail.ACLMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraAnnotationMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraApplicableFlagDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentDAOV2;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentMessageIdDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraDeletedMessageDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraFirstUnseenDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraIndexTableHandler;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxCounterDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxPathV3DAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxRecentsDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAOV3;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdToImapUidDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraThreadDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraThreadLookupDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraUserMailboxRightsDAO;
import org.apache.james.mailbox.cassandra.mail.task.RecomputeMailboxCountersService;
import org.apache.james.mailbox.cassandra.user.CassandraSubscriptionMapper;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.user.SubscriptionMapper;

public class CassandraMailboxSessionMapperFactory
extends MailboxSessionMapperFactory
implements AttachmentMapperFactory {
    private final UidProvider uidProvider;
    private final ModSeqProvider modSeqProvider;
    private final CassandraThreadDAO threadDAO;
    private final CassandraThreadLookupDAO threadLookupDAO;
    private final CassandraMessageDAO messageDAO;
    private final CassandraMessageDAOV3 messageDAOV3;
    private final CassandraMessageIdDAO messageIdDAO;
    private final CassandraMessageIdToImapUidDAO imapUidDAO;
    private final CassandraMailboxCounterDAO mailboxCounterDAO;
    private final CassandraMailboxRecentsDAO mailboxRecentsDAO;
    private final CassandraFirstUnseenDAO firstUnseenDAO;
    private final CassandraApplicableFlagDAO applicableFlagDAO;
    private final CassandraAttachmentDAOV2 attachmentDAOV2;
    private final CassandraDeletedMessageDAO deletedMessageDAO;
    private final BlobStore blobStore;
    private final CassandraAttachmentMessageIdDAO attachmentMessageIdDAO;
    private final ACLMapper aclMapper;
    private final CassandraUserMailboxRightsDAO userMailboxRightsDAO;
    private final CassandraConfiguration cassandraConfiguration;
    private final CassandraMailboxMapper cassandraMailboxMapper;
    private final CassandraSubscriptionMapper cassandraSubscriptionMapper;
    private final CassandraAttachmentMapper cassandraAttachmentMapper;
    private final CassandraMessageMapper cassandraMessageMapper;
    private final CassandraMessageIdMapper cassandraMessageIdMapper;
    private final CassandraAnnotationMapper cassandraAnnotationMapper;

    @Inject
    public CassandraMailboxSessionMapperFactory(UidProvider uidProvider, ModSeqProvider modSeqProvider, Session session, CassandraThreadDAO threadDAO, CassandraThreadLookupDAO threadLookupDAO, CassandraMessageDAO messageDAO, CassandraMessageDAOV3 messageDAOV3, CassandraMessageIdDAO messageIdDAO, CassandraMessageIdToImapUidDAO imapUidDAO, CassandraMailboxCounterDAO mailboxCounterDAO, CassandraMailboxRecentsDAO mailboxRecentsDAO, CassandraMailboxDAO mailboxDAO, CassandraMailboxPathV3DAO mailboxPathV3DAO, CassandraFirstUnseenDAO firstUnseenDAO, CassandraApplicableFlagDAO applicableFlagDAO, CassandraAttachmentDAOV2 attachmentDAOV2, CassandraDeletedMessageDAO deletedMessageDAO, BlobStore blobStore, CassandraAttachmentMessageIdDAO attachmentMessageIdDAO, ACLMapper aclMapper, CassandraUserMailboxRightsDAO userMailboxRightsDAO, RecomputeMailboxCountersService recomputeMailboxCountersService, CassandraUtils cassandraUtils, CassandraConfiguration cassandraConfiguration) {
        this.uidProvider = uidProvider;
        this.modSeqProvider = modSeqProvider;
        this.threadDAO = threadDAO;
        this.threadLookupDAO = threadLookupDAO;
        this.messageDAO = messageDAO;
        this.messageDAOV3 = messageDAOV3;
        this.messageIdDAO = messageIdDAO;
        this.imapUidDAO = imapUidDAO;
        this.mailboxCounterDAO = mailboxCounterDAO;
        this.mailboxRecentsDAO = mailboxRecentsDAO;
        this.firstUnseenDAO = firstUnseenDAO;
        this.attachmentDAOV2 = attachmentDAOV2;
        this.deletedMessageDAO = deletedMessageDAO;
        this.applicableFlagDAO = applicableFlagDAO;
        this.blobStore = blobStore;
        this.attachmentMessageIdDAO = attachmentMessageIdDAO;
        this.aclMapper = aclMapper;
        this.userMailboxRightsDAO = userMailboxRightsDAO;
        this.cassandraConfiguration = cassandraConfiguration;
        CassandraIndexTableHandler indexTableHandler = new CassandraIndexTableHandler(mailboxRecentsDAO, mailboxCounterDAO, firstUnseenDAO, applicableFlagDAO, deletedMessageDAO);
        this.cassandraMailboxMapper = new CassandraMailboxMapper(mailboxDAO, mailboxPathV3DAO, userMailboxRightsDAO, aclMapper, cassandraConfiguration);
        this.cassandraSubscriptionMapper = new CassandraSubscriptionMapper(session, cassandraUtils);
        this.cassandraAttachmentMapper = new CassandraAttachmentMapper(attachmentDAOV2, blobStore, attachmentMessageIdDAO);
        this.cassandraMessageMapper = new CassandraMessageMapper(uidProvider, modSeqProvider, this.cassandraAttachmentMapper, messageDAO, messageDAOV3, messageIdDAO, imapUidDAO, mailboxCounterDAO, mailboxRecentsDAO, applicableFlagDAO, indexTableHandler, firstUnseenDAO, deletedMessageDAO, blobStore, cassandraConfiguration, recomputeMailboxCountersService);
        this.cassandraMessageIdMapper = new CassandraMessageIdMapper(this.cassandraMailboxMapper, mailboxDAO, this.cassandraAttachmentMapper, imapUidDAO, messageIdDAO, messageDAO, messageDAOV3, indexTableHandler, modSeqProvider, blobStore, cassandraConfiguration);
        this.cassandraAnnotationMapper = new CassandraAnnotationMapper(session, cassandraUtils);
    }

    public CassandraMessageMapper createMessageMapper(MailboxSession mailboxSession) {
        return this.cassandraMessageMapper;
    }

    public MessageIdMapper createMessageIdMapper(MailboxSession mailboxSession) {
        return this.cassandraMessageIdMapper;
    }

    public MailboxMapper createMailboxMapper(MailboxSession mailboxSession) {
        return this.cassandraMailboxMapper;
    }

    public CassandraAttachmentMapper createAttachmentMapper(MailboxSession mailboxSession) {
        return this.cassandraAttachmentMapper;
    }

    public SubscriptionMapper createSubscriptionMapper(MailboxSession mailboxSession) {
        return this.cassandraSubscriptionMapper;
    }

    public ModSeqProvider getModSeqProvider() {
        return this.modSeqProvider;
    }

    public UidProvider getUidProvider() {
        return this.uidProvider;
    }

    public AnnotationMapper createAnnotationMapper(MailboxSession mailboxSession) {
        return this.cassandraAnnotationMapper;
    }

    public AttachmentMapper getAttachmentMapper(MailboxSession session) {
        return this.cassandraAttachmentMapper;
    }

    public DeleteMessageListener deleteMessageListener() {
        return new DeleteMessageListener(this.threadDAO, this.threadLookupDAO, this.imapUidDAO, this.messageIdDAO, this.messageDAO, this.messageDAOV3, this.attachmentDAOV2, this.attachmentMessageIdDAO, this.aclMapper, this.userMailboxRightsDAO, this.applicableFlagDAO, this.firstUnseenDAO, this.deletedMessageDAO, this.mailboxCounterDAO, this.mailboxRecentsDAO, this.blobStore, this.cassandraConfiguration);
    }
}

