/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.indexer;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.task.Task;

public interface ReIndexer {
    public Task reIndex(Username var1, RunningOptions var2) throws MailboxException;

    public Task reIndex(MailboxPath var1, RunningOptions var2) throws MailboxException;

    public Task reIndex(MailboxId var1, RunningOptions var2) throws MailboxException;

    public Task reIndex(RunningOptions var1) throws MailboxException;

    public Task reIndex(MailboxPath var1, MessageUid var2) throws MailboxException;

    public Task reIndex(MailboxId var1, MessageUid var2) throws MailboxException;

    public Task reIndex(ReIndexingExecutionFailures var1, RunningOptions var2) throws MailboxException;

    public static class RunningOptions {
        private static final Mode DEFAULT_MODE = Mode.REBUILD_ALL;
        private static final int DEFAULT_MESSAGES_PER_SECONDS = 50;
        public static final RunningOptions DEFAULT = RunningOptions.builder().build();
        private final int messagesPerSecond;
        private final Mode mode;

        public static Builder builder() {
            return new Builder();
        }

        public static Optional<Mode> parseMode(String optionalMode) {
            return Optional.ofNullable(optionalMode).flatMap(Mode::fromString);
        }

        private RunningOptions(int messagesPerSecond, Mode mode) {
            this.messagesPerSecond = messagesPerSecond;
            this.mode = mode;
        }

        public int getMessagesPerSecond() {
            return this.messagesPerSecond;
        }

        public Mode getMode() {
            return this.mode;
        }

        public static enum Mode {
            REBUILD_ALL("rebuildAll"),
            REBUILD_ALL_NO_CLEANUP("rebuildAllNoCleanup"),
            FIX_OUTDATED("fixOutdated");

            private final String value;

            private Mode(String value) {
                this.value = value;
            }

            String getValue() {
                return this.value;
            }

            static Optional<Mode> fromString(String optionalMode) {
                return Stream.of(Mode.values()).filter(mode -> mode.getValue().equalsIgnoreCase(optionalMode)).findFirst();
            }
        }

        public static class Builder {
            private Optional<Integer> messagesPerSecond = Optional.empty();
            private Optional<Mode> mode = Optional.empty();

            public Builder messagesPerSeconds(Optional<Integer> messagesPerSecond) {
                this.messagesPerSecond = messagesPerSecond;
                return this;
            }

            public Builder mode(Optional<Mode> mode) {
                this.mode = mode;
                return this;
            }

            public Builder mode(Mode mode) {
                return this.mode(Optional.of(mode));
            }

            public RunningOptions build() {
                return new RunningOptions(this.messagesPerSecond.orElse(50), this.mode.orElse(DEFAULT_MODE));
            }
        }
    }
}

