/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.mailbox;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.functions.operators.BinaryOperatorChainer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.util.GuavaUtils;
import org.apache.james.util.OptionalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rights {
    @VisibleForTesting
    static final Optional<Boolean> UNSUPPORTED = Optional.empty();
    public static final Rights EMPTY = new Rights((Multimap<Username, Right>)ArrayListMultimap.create());
    private static final Logger LOGGER = LoggerFactory.getLogger(Rights.class);
    private final Multimap<Username, Right> rights;

    public static Builder builder() {
        return new Builder();
    }

    public static Rights fromACL(MailboxACL acl) {
        return acl.getEntries().entrySet().stream().filter(entry -> Rights.isSupported((MailboxACL.EntryKey)entry.getKey())).map(Rights::toRightsBuilder).reduce(Rights.builder(), Builder::combine).build();
    }

    private static Builder toRightsBuilder(Map.Entry<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights> entry) {
        return Rights.builder().delegateTo(Username.of((String)entry.getKey().getName()), Rights.fromACL(entry.getValue()));
    }

    private static List<Right> fromACL(MailboxACL.Rfc4314Rights rights) {
        return (List)rights.list().stream().flatMap(right -> Right.forRight(right).stream()).collect(ImmutableList.toImmutableList());
    }

    private static boolean isSupported(MailboxACL.EntryKey key) {
        if (key.isNegative()) {
            LOGGER.info("Negative keys are not supported");
            return false;
        }
        if (key.equals((Object)MailboxACL.OWNER_KEY)) {
            return false;
        }
        if (key.getNameType() != MailboxACL.NameType.user) {
            LOGGER.info("{} is not supported. Only 'user' is.", (Object)key.getNameType());
            return false;
        }
        return true;
    }

    @JsonCreator
    public Rights(Map<Username, List<Right>> rights) {
        this((Multimap<Username, Right>)GuavaUtils.toMultimap(rights));
    }

    private Rights(Multimap<Username, Right> rights) {
        this.rights = rights;
    }

    @JsonAnyGetter
    public Map<Username, Collection<Right>> getRights() {
        return this.rights.asMap();
    }

    public Rights removeEntriesFor(Username username) {
        return new Rights((Multimap<Username, Right>)((Multimap)this.rights.asMap().entrySet().stream().filter(entry -> !((Username)entry.getKey()).equals((Object)username)).flatMap(entry -> ((Collection)entry.getValue()).stream().map(v -> Pair.of((Object)((Username)entry.getKey()), (Object)v))).collect(ImmutableListMultimap.toImmutableListMultimap(Pair::getKey, Pair::getValue))));
    }

    public MailboxACL toMailboxAcl() {
        BinaryOperatorChainer union = Throwing.binaryOperator(MailboxACL::union);
        return this.rights.asMap().entrySet().stream().map(entry -> new MailboxACL((Map)ImmutableMap.of((Object)MailboxACL.EntryKey.createUserEntryKey((Username)((Username)entry.getKey())), (Object)this.toMailboxAclRights((Collection)entry.getValue())))).reduce(MailboxACL.EMPTY, (BinaryOperator<MailboxACL>)union);
    }

    public Optional<Boolean> mayReadItems(Username username) {
        return this.containsRight(username, Right.Read);
    }

    public Optional<Boolean> mayAddItems(Username username) {
        return this.containsRight(username, Right.Insert);
    }

    public Optional<Boolean> mayCreateChild(Username username) {
        return UNSUPPORTED;
    }

    public Optional<Boolean> mayRemoveItems(Username username) {
        return this.containsRight(username, Right.DeleteMessages);
    }

    public Optional<Boolean> mayRename(Username username) {
        return UNSUPPORTED;
    }

    public Optional<Boolean> mayDelete(Username username) {
        return UNSUPPORTED;
    }

    private Optional<Boolean> containsRight(Username username, Right right) {
        return Optional.ofNullable(this.rights.get((Object)username)).filter(Predicate.not(Collection::isEmpty)).map(rightList -> rightList.contains((Object)right));
    }

    private MailboxACL.Rfc4314Rights toMailboxAclRights(Collection<Right> rights) {
        BinaryOperatorChainer union = Throwing.binaryOperator(MailboxACL.Rfc4314Rights::union);
        return rights.stream().map(Right::toMailboxRight).map(Throwing.function(xva$0 -> new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{xva$0}))).reduce(new MailboxACL.Rfc4314Rights(new MailboxACL.Right[0]), union);
    }

    public final boolean equals(Object o) {
        if (o instanceof Rights) {
            Rights that = (Rights)o;
            return Objects.equals(this.rights, that.rights);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.rights);
    }

    public static class Builder {
        private Multimap<Username, Right> rights = ArrayListMultimap.create();

        public Builder delegateTo(Username username, Right ... rights) {
            this.delegateTo(username, Arrays.asList(rights));
            return this;
        }

        public Builder delegateTo(Username username, Collection<Right> rights) {
            this.rights.putAll((Object)username, rights);
            return this;
        }

        public Builder combine(Builder builder) {
            this.rights.putAll(builder.rights);
            return this;
        }

        public Rights build() {
            return new Rights(this.rights);
        }
    }

    public static enum Right {
        Administer(MailboxACL.Right.Administer),
        Expunge(MailboxACL.Right.PerformExpunge),
        Insert(MailboxACL.Right.Insert),
        Lookup(MailboxACL.Right.Lookup),
        Read(MailboxACL.Right.Read),
        Seen(MailboxACL.Right.WriteSeenFlag),
        DeleteMessages(MailboxACL.Right.DeleteMessages),
        Write(MailboxACL.Right.Write);

        private final MailboxACL.Right right;

        private Right(MailboxACL.Right right) {
            this.right = right;
        }

        @JsonValue
        public char asCharacter() {
            return this.right.asCharacter();
        }

        public MailboxACL.Right toMailboxRight() {
            return this.right;
        }

        public static Optional<Right> forRight(MailboxACL.Right right) {
            return OptionalUtils.executeIfEmpty(Arrays.stream(Right.values()).filter(jmapRight -> jmapRight.right == right).findAny(), () -> LOGGER.warn("Non handled right '{}'", (Object)right));
        }

        public static Right forChar(char c) {
            return Arrays.stream(Right.values()).filter(right -> right.asCharacter() == c).findAny().orElseThrow(() -> new IllegalArgumentException("No matching right for '" + c + "'"));
        }
    }
}

