/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.util;

import com.jakewharton.byteunits.BinaryByteUnit;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class SizeUtils {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.US));

    public static String humanReadableSize(Number size) {
        return SizeUtils.humanReadableSize(size.longValue());
    }

    private static String humanReadableSize(long size) {
        if (size < 0L) {
            return "-" + SizeUtils.humanReadableSize(-size);
        }
        return BinaryByteUnit.format((long)size, (NumberFormat)DECIMAL_FORMAT);
    }
}

