/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.model.Filter;
import org.apache.james.jmap.draft.model.Number;

@JsonDeserialize(builder=Builder.class)
public class GetMessageListRequest
implements JmapRequest {
    private final Optional<String> accountId;
    private final Optional<Filter> filter;
    private final List<String> sort;
    private final Optional<Boolean> collapseThreads;
    private final Optional<Number> position;
    private final Optional<String> anchor;
    private final Optional<Number> anchorOffset;
    private final Optional<Number> limit;
    private final Optional<Boolean> fetchThreads;
    private final Optional<Boolean> fetchMessages;
    private final List<String> fetchMessageProperties;
    private final Optional<Boolean> fetchSearchSnippets;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    GetMessageListRequest(Optional<String> accountId, Optional<Filter> filter, List<String> sort, Optional<Boolean> collapseThreads, Optional<Number> position, Optional<String> anchor, Optional<Number> anchorOffset, Optional<Number> limit, Optional<Boolean> fetchThreads, Optional<Boolean> fetchMessages, List<String> fetchMessageProperties, Optional<Boolean> fetchSearchSnippets) {
        this.accountId = accountId;
        this.filter = filter;
        this.sort = sort;
        this.collapseThreads = collapseThreads;
        this.position = position;
        this.anchor = anchor;
        this.anchorOffset = anchorOffset;
        this.limit = limit;
        this.fetchThreads = fetchThreads;
        this.fetchMessages = fetchMessages;
        this.fetchMessageProperties = fetchMessageProperties;
        this.fetchSearchSnippets = fetchSearchSnippets;
    }

    public Optional<String> getAccountId() {
        return this.accountId;
    }

    public Optional<Filter> getFilter() {
        return this.filter;
    }

    public List<String> getSort() {
        return this.sort;
    }

    public Optional<Boolean> isCollapseThreads() {
        return this.collapseThreads;
    }

    public Optional<Number> getPosition() {
        return this.position;
    }

    public Optional<String> getAnchor() {
        return this.anchor;
    }

    public Optional<Number> getAnchorOffset() {
        return this.anchorOffset;
    }

    public Optional<Number> getLimit() {
        return this.limit;
    }

    public Optional<Boolean> isFetchThreads() {
        return this.fetchThreads;
    }

    public Optional<Boolean> isFetchMessages() {
        return this.fetchMessages;
    }

    public List<String> getFetchMessageProperties() {
        return this.fetchMessageProperties;
    }

    public Optional<Boolean> isFetchSearchSnippets() {
        return this.fetchSearchSnippets;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private String accountId;
        private Filter filter;
        private final ImmutableList.Builder<String> sort;
        private Boolean collapseThreads;
        private Optional<Number> position = Optional.empty();
        private String anchor;
        private Number anchorOffset;
        private Number limit;
        private Boolean fetchThreads;
        private Boolean fetchMessages;
        private final ImmutableList.Builder<String> fetchMessageProperties;
        private Boolean fetchSearchSnippets;

        private Builder() {
            this.sort = ImmutableList.builder();
            this.fetchMessageProperties = ImmutableList.builder();
        }

        public Builder accountId(String accountId) {
            throw new NotImplementedException("not implemented");
        }

        public Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public Builder sort(List<String> sort) {
            this.sort.addAll(sort);
            return this;
        }

        public Builder collapseThreads(boolean collapseThreads) {
            this.collapseThreads = collapseThreads;
            return this;
        }

        public Builder position(long position) {
            this.position = Optional.of(Number.DEFAULT_FACTORY.from(position).orElseThrow(() -> new IllegalArgumentException("value should be positive and less than 2^53")));
            return this;
        }

        public Builder anchor(String anchor) {
            throw new NotImplementedException("not implemented");
        }

        public Builder anchorOffset(int anchorOffset) {
            throw new NotImplementedException("not implemented");
        }

        public Builder limit(long limit) {
            this.limit = Number.DEFAULT_FACTORY.from(limit).orElseThrow(() -> new IllegalArgumentException("value should be positive and less than 2^53"));
            return this;
        }

        public Builder fetchThreads(boolean fetchThreads) {
            throw new NotImplementedException("not implemented");
        }

        public Builder fetchMessages(boolean fetchMessages) {
            this.fetchMessages = fetchMessages;
            return this;
        }

        public Builder fetchMessageProperties(List<String> fetchMessageProperties) {
            this.fetchMessageProperties.addAll(fetchMessageProperties);
            return this;
        }

        public Builder fetchSearchSnippets(boolean fetchSearchSnippets) {
            throw new NotImplementedException("not implemented");
        }

        public GetMessageListRequest build() {
            return new GetMessageListRequest(Optional.ofNullable(this.accountId), Optional.ofNullable(this.filter), (List<String>)this.sort.build(), Optional.ofNullable(this.collapseThreads), this.position, Optional.ofNullable(this.anchor), Optional.ofNullable(this.anchorOffset), Optional.ofNullable(this.limit), Optional.ofNullable(this.fetchThreads), Optional.ofNullable(this.fetchMessages), (List<String>)this.fetchMessageProperties.build(), Optional.ofNullable(this.fetchSearchSnippets));
        }
    }
}

