/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.components;

import com.datastax.driver.core.Statement;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.CreateType;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.james.backends.cassandra.components.CassandraTable;
import org.apache.james.backends.cassandra.components.CassandraType;

public interface CassandraModule {
    public static final CassandraModule EMPTY_MODULE = CassandraModule.builder().build();

    public static Builder builder() {
        return new Builder();
    }

    public static TypeBuilder type(String typeName) {
        return CassandraModule.builder().type(typeName);
    }

    public static TableBuilder table(String tableName) {
        return CassandraModule.builder().table(tableName);
    }

    public static CassandraModule aggregateModules(CassandraModule ... modules) {
        return CassandraModule.aggregateModules(Arrays.asList(modules));
    }

    public static CassandraModule aggregateModules(Collection<CassandraModule> modules) {
        return CassandraModule.builder().modules(modules).build();
    }

    public List<CassandraTable> moduleTables();

    public List<CassandraType> moduleTypes();

    public static class TypeBuilder {
        private final Builder originalBuilderReference;
        private final String typeName;

        private TypeBuilder(Builder originalBuilderReference, String typeName) {
            this.originalBuilderReference = originalBuilderReference;
            this.typeName = typeName;
        }

        public Builder statement(Function<CreateType, CreateType> createStatement) {
            return this.originalBuilderReference.addType(new CassandraType(this.typeName, createStatement.apply((CreateType)SchemaBuilder.createType((String)this.typeName).ifNotExists())));
        }
    }

    public static class TableBuilder {
        private final Builder originalBuilderReference;
        private final String tableName;
        private Optional<String> comment;
        private Optional<Function<Create.Options, Create.Options>> options;

        private TableBuilder(Builder originalBuilderReference, String tableName) {
            this.originalBuilderReference = originalBuilderReference;
            this.tableName = tableName;
            this.comment = Optional.empty();
            this.options = Optional.empty();
        }

        public TableBuilder comment(String comment) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)comment) ? 1 : 0) != 0, (Object)"`comment` can not be null or empty");
            this.comment = Optional.of(comment);
            return this;
        }

        public TableBuilder options(Function<Create.Options, Create.Options> options) {
            this.options = Optional.of(options);
            return this;
        }

        public Builder statement(Function<Create, Create> toCreateStatement) {
            Preconditions.checkState((boolean)this.comment.isPresent(), (Object)"`comment` is compulsory");
            Create createStatement = toCreateStatement.apply((Create)SchemaBuilder.createTable((String)this.tableName).ifNotExists());
            return this.originalBuilderReference.addTable(new CassandraTable(this.tableName, (Statement)this.options.orElse(Function.identity()).apply((Create.Options)createStatement.withOptions().comment(this.comment.get()))));
        }
    }

    public static class Builder {
        private ImmutableList.Builder<CassandraTable> tables = ImmutableList.builder();
        private ImmutableList.Builder<CassandraType> types = ImmutableList.builder();

        private Builder() {
        }

        public TableBuilder table(String tableName) {
            return new TableBuilder(this, tableName);
        }

        public TypeBuilder type(String typeName) {
            return new TypeBuilder(this, typeName);
        }

        public Builder module(CassandraModule module) {
            return this.modules((Collection<CassandraModule>)ImmutableList.of((Object)module));
        }

        public Builder modules(Collection<CassandraModule> modules) {
            this.tables.addAll((Iterable)modules.stream().flatMap(module -> module.moduleTables().stream()).collect(ImmutableList.toImmutableList()));
            this.types.addAll((Iterable)modules.stream().flatMap(module -> module.moduleTypes().stream()).collect(ImmutableList.toImmutableList()));
            return this;
        }

        public Builder modules(CassandraModule ... modules) {
            return this.modules(Arrays.asList(modules));
        }

        public Impl build() {
            return new Impl((List<CassandraTable>)this.tables.build(), (List<CassandraType>)this.types.build());
        }

        private Builder addTable(CassandraTable table) {
            this.tables.add((Object)table);
            return this;
        }

        private Builder addType(CassandraType type) {
            this.types.add((Object)type);
            return this;
        }
    }

    public static class Impl
    implements CassandraModule {
        private final List<CassandraTable> tables;
        private final List<CassandraType> types;

        private Impl(List<CassandraTable> tables, List<CassandraType> types) {
            this.tables = tables;
            this.types = types;
        }

        @Override
        public List<CassandraTable> moduleTables() {
            return this.tables;
        }

        @Override
        public List<CassandraType> moduleTypes() {
            return this.types;
        }
    }
}

