/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.ids;

import com.datastax.driver.core.utils.UUIDs;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import org.apache.james.mailbox.model.MailboxId;

public class CassandraId
implements MailboxId,
Serializable {
    private final UUID id;

    public static CassandraId timeBased() {
        return CassandraId.of(UUIDs.timeBased());
    }

    public static CassandraId of(UUID id) {
        return new CassandraId(id);
    }

    public static CassandraId of(String serialized) {
        return new CassandraId(UUID.fromString(serialized));
    }

    private CassandraId(UUID id) {
        this.id = id;
    }

    public String serialize() {
        return this.id.toString();
    }

    public UUID asUuid() {
        return this.id;
    }

    public final boolean equals(Object o) {
        if (o instanceof CassandraId) {
            CassandraId other = (CassandraId)o;
            return Objects.equals(this.id, other.id);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }

    public static class Factory
    implements MailboxId.Factory {
        public CassandraId fromString(String serialized) {
            return CassandraId.of(serialized);
        }
    }
}

