/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicLong;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.MOSTLY_THREADSAFE)
public final class LDAPConnectionStatistics
implements Serializable {
    private static final long serialVersionUID = -1096417617572481790L;
    @NotNull
    private final AtomicLong numAbandonRequests = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numAddRequests = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numAddResponses = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numBindRequests = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numBindResponses = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numCompareRequests = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numCompareResponses = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numConnects = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numDeleteRequests = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numDeleteResponses = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numDisconnects = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numExtendedRequests = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numExtendedResponses = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numModifyRequests = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numModifyResponses = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numModifyDNRequests = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numModifyDNResponses = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numSearchRequests = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numSearchEntryResponses = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numSearchReferenceResponses = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numSearchDoneResponses = new AtomicLong(0L);
    @NotNull
    private final AtomicLong numUnbindRequests = new AtomicLong(0L);
    @NotNull
    private final AtomicLong totalAddResponseTime = new AtomicLong(0L);
    @NotNull
    private final AtomicLong totalBindResponseTime = new AtomicLong(0L);
    @NotNull
    private final AtomicLong totalCompareResponseTime = new AtomicLong(0L);
    @NotNull
    private final AtomicLong totalDeleteResponseTime = new AtomicLong(0L);
    @NotNull
    private final AtomicLong totalExtendedResponseTime = new AtomicLong(0L);
    @NotNull
    private final AtomicLong totalModifyResponseTime = new AtomicLong(0L);
    @NotNull
    private final AtomicLong totalModifyDNResponseTime = new AtomicLong(0L);
    @NotNull
    private final AtomicLong totalSearchResponseTime = new AtomicLong(0L);

    public void reset() {
        this.numAbandonRequests.set(0L);
        this.numAddRequests.set(0L);
        this.numAddResponses.set(0L);
        this.numBindRequests.set(0L);
        this.numBindResponses.set(0L);
        this.numCompareRequests.set(0L);
        this.numCompareResponses.set(0L);
        this.numConnects.set(0L);
        this.numDeleteRequests.set(0L);
        this.numDeleteResponses.set(0L);
        this.numDisconnects.set(0L);
        this.numExtendedRequests.set(0L);
        this.numExtendedResponses.set(0L);
        this.numModifyRequests.set(0L);
        this.numModifyResponses.set(0L);
        this.numModifyDNRequests.set(0L);
        this.numModifyDNResponses.set(0L);
        this.numSearchRequests.set(0L);
        this.numSearchEntryResponses.set(0L);
        this.numSearchReferenceResponses.set(0L);
        this.numSearchDoneResponses.set(0L);
        this.numUnbindRequests.set(0L);
        this.totalAddResponseTime.set(0L);
        this.totalBindResponseTime.set(0L);
        this.totalCompareResponseTime.set(0L);
        this.totalDeleteResponseTime.set(0L);
        this.totalExtendedResponseTime.set(0L);
        this.totalModifyResponseTime.set(0L);
        this.totalModifyDNResponseTime.set(0L);
        this.totalSearchResponseTime.set(0L);
    }

    public long getNumConnects() {
        return this.numConnects.get();
    }

    void incrementNumConnects() {
        this.numConnects.incrementAndGet();
    }

    public long getNumDisconnects() {
        return this.numDisconnects.get();
    }

    void incrementNumDisconnects() {
        this.numDisconnects.incrementAndGet();
    }

    public long getNumAbandonRequests() {
        return this.numAbandonRequests.get();
    }

    void incrementNumAbandonRequests() {
        this.numAbandonRequests.incrementAndGet();
    }

    public long getNumAddRequests() {
        return this.numAddRequests.get();
    }

    void incrementNumAddRequests() {
        this.numAddRequests.incrementAndGet();
    }

    public long getNumAddResponses() {
        return this.numAddResponses.get();
    }

    void incrementNumAddResponses(long responseTime) {
        this.numAddResponses.incrementAndGet();
        if (responseTime > 0L) {
            this.totalAddResponseTime.addAndGet(responseTime);
        }
    }

    public long getTotalAddResponseTimeNanos() {
        return this.totalAddResponseTime.get();
    }

    public long getTotalAddResponseTimeMillis() {
        return Math.round((double)this.totalAddResponseTime.get() / 1000000.0);
    }

    public double getAverageAddResponseTimeNanos() {
        long totalTime = this.totalAddResponseTime.get();
        long totalCount = this.numAddResponses.get();
        if (totalTime > 0L) {
            return 1.0 * (double)totalTime / (double)totalCount;
        }
        return Double.NaN;
    }

    public double getAverageAddResponseTimeMillis() {
        long totalTime = this.totalAddResponseTime.get();
        long totalCount = this.numAddResponses.get();
        if (totalTime > 0L) {
            return (double)totalTime / 1000000.0 / (double)totalCount;
        }
        return Double.NaN;
    }

    public long getNumBindRequests() {
        return this.numBindRequests.get();
    }

    void incrementNumBindRequests() {
        this.numBindRequests.incrementAndGet();
    }

    public long getNumBindResponses() {
        return this.numBindResponses.get();
    }

    void incrementNumBindResponses(long responseTime) {
        this.numBindResponses.incrementAndGet();
        if (responseTime > 0L) {
            this.totalBindResponseTime.addAndGet(responseTime);
        }
    }

    public long getTotalBindResponseTimeNanos() {
        return this.totalBindResponseTime.get();
    }

    public long getTotalBindResponseTimeMillis() {
        return Math.round((double)this.totalBindResponseTime.get() / 1000000.0);
    }

    public double getAverageBindResponseTimeNanos() {
        long totalTime = this.totalBindResponseTime.get();
        long totalCount = this.numBindResponses.get();
        if (totalTime > 0L) {
            return 1.0 * (double)totalTime / (double)totalCount;
        }
        return Double.NaN;
    }

    public double getAverageBindResponseTimeMillis() {
        long totalTime = this.totalBindResponseTime.get();
        long totalCount = this.numBindResponses.get();
        if (totalTime > 0L) {
            return (double)totalTime / 1000000.0 / (double)totalCount;
        }
        return Double.NaN;
    }

    public long getNumCompareRequests() {
        return this.numCompareRequests.get();
    }

    void incrementNumCompareRequests() {
        this.numCompareRequests.incrementAndGet();
    }

    public long getNumCompareResponses() {
        return this.numCompareResponses.get();
    }

    void incrementNumCompareResponses(long responseTime) {
        this.numCompareResponses.incrementAndGet();
        if (responseTime > 0L) {
            this.totalCompareResponseTime.addAndGet(responseTime);
        }
    }

    public long getTotalCompareResponseTimeNanos() {
        return this.totalCompareResponseTime.get();
    }

    public long getTotalCompareResponseTimeMillis() {
        return Math.round((double)this.totalCompareResponseTime.get() / 1000000.0);
    }

    public double getAverageCompareResponseTimeNanos() {
        long totalTime = this.totalCompareResponseTime.get();
        long totalCount = this.numCompareResponses.get();
        if (totalTime > 0L) {
            return 1.0 * (double)totalTime / (double)totalCount;
        }
        return Double.NaN;
    }

    public double getAverageCompareResponseTimeMillis() {
        long totalTime = this.totalCompareResponseTime.get();
        long totalCount = this.numCompareResponses.get();
        if (totalTime > 0L) {
            return (double)totalTime / 1000000.0 / (double)totalCount;
        }
        return Double.NaN;
    }

    public long getNumDeleteRequests() {
        return this.numDeleteRequests.get();
    }

    void incrementNumDeleteRequests() {
        this.numDeleteRequests.incrementAndGet();
    }

    public long getNumDeleteResponses() {
        return this.numDeleteResponses.get();
    }

    void incrementNumDeleteResponses(long responseTime) {
        this.numDeleteResponses.incrementAndGet();
        if (responseTime > 0L) {
            this.totalDeleteResponseTime.addAndGet(responseTime);
        }
    }

    public long getTotalDeleteResponseTimeNanos() {
        return this.totalDeleteResponseTime.get();
    }

    public long getTotalDeleteResponseTimeMillis() {
        return Math.round((double)this.totalDeleteResponseTime.get() / 1000000.0);
    }

    public double getAverageDeleteResponseTimeNanos() {
        long totalTime = this.totalDeleteResponseTime.get();
        long totalCount = this.numDeleteResponses.get();
        if (totalTime > 0L) {
            return 1.0 * (double)totalTime / (double)totalCount;
        }
        return Double.NaN;
    }

    public double getAverageDeleteResponseTimeMillis() {
        long totalTime = this.totalDeleteResponseTime.get();
        long totalCount = this.numDeleteResponses.get();
        if (totalTime > 0L) {
            return (double)totalTime / 1000000.0 / (double)totalCount;
        }
        return Double.NaN;
    }

    public long getNumExtendedRequests() {
        return this.numExtendedRequests.get();
    }

    void incrementNumExtendedRequests() {
        this.numExtendedRequests.incrementAndGet();
    }

    public long getNumExtendedResponses() {
        return this.numExtendedResponses.get();
    }

    void incrementNumExtendedResponses(long responseTime) {
        this.numExtendedResponses.incrementAndGet();
        if (responseTime > 0L) {
            this.totalExtendedResponseTime.addAndGet(responseTime);
        }
    }

    public long getTotalExtendedResponseTimeNanos() {
        return this.totalExtendedResponseTime.get();
    }

    public long getTotalExtendedResponseTimeMillis() {
        return Math.round((double)this.totalExtendedResponseTime.get() / 1000000.0);
    }

    public double getAverageExtendedResponseTimeNanos() {
        long totalTime = this.totalExtendedResponseTime.get();
        long totalCount = this.numExtendedResponses.get();
        if (totalTime > 0L) {
            return 1.0 * (double)totalTime / (double)totalCount;
        }
        return Double.NaN;
    }

    public double getAverageExtendedResponseTimeMillis() {
        long totalTime = this.totalExtendedResponseTime.get();
        long totalCount = this.numExtendedResponses.get();
        if (totalTime > 0L) {
            return (double)totalTime / 1000000.0 / (double)totalCount;
        }
        return Double.NaN;
    }

    public long getNumModifyRequests() {
        return this.numModifyRequests.get();
    }

    void incrementNumModifyRequests() {
        this.numModifyRequests.incrementAndGet();
    }

    public long getNumModifyResponses() {
        return this.numModifyResponses.get();
    }

    void incrementNumModifyResponses(long responseTime) {
        this.numModifyResponses.incrementAndGet();
        if (responseTime > 0L) {
            this.totalModifyResponseTime.addAndGet(responseTime);
        }
    }

    public long getTotalModifyResponseTimeNanos() {
        return this.totalModifyResponseTime.get();
    }

    public long getTotalModifyResponseTimeMillis() {
        return Math.round((double)this.totalModifyResponseTime.get() / 1000000.0);
    }

    public double getAverageModifyResponseTimeNanos() {
        long totalTime = this.totalModifyResponseTime.get();
        long totalCount = this.numModifyResponses.get();
        if (totalTime > 0L) {
            return 1.0 * (double)totalTime / (double)totalCount;
        }
        return Double.NaN;
    }

    public double getAverageModifyResponseTimeMillis() {
        long totalTime = this.totalModifyResponseTime.get();
        long totalCount = this.numModifyResponses.get();
        if (totalTime > 0L) {
            return (double)totalTime / 1000000.0 / (double)totalCount;
        }
        return Double.NaN;
    }

    public long getNumModifyDNRequests() {
        return this.numModifyDNRequests.get();
    }

    void incrementNumModifyDNRequests() {
        this.numModifyDNRequests.incrementAndGet();
    }

    public long getNumModifyDNResponses() {
        return this.numModifyDNResponses.get();
    }

    void incrementNumModifyDNResponses(long responseTime) {
        this.numModifyDNResponses.incrementAndGet();
        if (responseTime > 0L) {
            this.totalModifyDNResponseTime.addAndGet(responseTime);
        }
    }

    public long getTotalModifyDNResponseTimeNanos() {
        return this.totalModifyDNResponseTime.get();
    }

    public long getTotalModifyDNResponseTimeMillis() {
        return Math.round((double)this.totalModifyDNResponseTime.get() / 1000000.0);
    }

    public double getAverageModifyDNResponseTimeNanos() {
        long totalTime = this.totalModifyDNResponseTime.get();
        long totalCount = this.numModifyDNResponses.get();
        if (totalTime > 0L) {
            return 1.0 * (double)totalTime / (double)totalCount;
        }
        return Double.NaN;
    }

    public double getAverageModifyDNResponseTimeMillis() {
        long totalTime = this.totalModifyDNResponseTime.get();
        long totalCount = this.numModifyDNResponses.get();
        if (totalTime > 0L) {
            return (double)totalTime / 1000000.0 / (double)totalCount;
        }
        return Double.NaN;
    }

    public long getNumSearchRequests() {
        return this.numSearchRequests.get();
    }

    void incrementNumSearchRequests() {
        this.numSearchRequests.incrementAndGet();
    }

    public long getNumSearchEntryResponses() {
        return this.numSearchEntryResponses.get();
    }

    public long getNumSearchReferenceResponses() {
        return this.numSearchReferenceResponses.get();
    }

    public long getNumSearchDoneResponses() {
        return this.numSearchDoneResponses.get();
    }

    void incrementNumSearchResponses(int numEntries, int numReferences, long responseTime) {
        this.numSearchEntryResponses.addAndGet(numEntries);
        this.numSearchReferenceResponses.addAndGet(numReferences);
        this.numSearchDoneResponses.incrementAndGet();
        if (responseTime > 0L) {
            this.totalSearchResponseTime.addAndGet(responseTime);
        }
    }

    public long getTotalSearchResponseTimeNanos() {
        return this.totalSearchResponseTime.get();
    }

    public long getTotalSearchResponseTimeMillis() {
        return Math.round((double)this.totalSearchResponseTime.get() / 1000000.0);
    }

    public double getAverageSearchResponseTimeNanos() {
        long totalTime = this.totalSearchResponseTime.get();
        long totalCount = this.numSearchDoneResponses.get();
        if (totalTime > 0L) {
            return 1.0 * (double)totalTime / (double)totalCount;
        }
        return Double.NaN;
    }

    public double getAverageSearchResponseTimeMillis() {
        long totalTime = this.totalSearchResponseTime.get();
        long totalCount = this.numSearchDoneResponses.get();
        if (totalTime > 0L) {
            return (double)totalTime / 1000000.0 / (double)totalCount;
        }
        return Double.NaN;
    }

    public long getNumUnbindRequests() {
        return this.numUnbindRequests.get();
    }

    void incrementNumUnbindRequests() {
        this.numUnbindRequests.incrementAndGet();
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        long connects = this.numConnects.get();
        long disconnects = this.numDisconnects.get();
        long abandonRequests = this.numAbandonRequests.get();
        long addRequests = this.numAddRequests.get();
        long addResponses = this.numAddResponses.get();
        long addTimes = this.totalAddResponseTime.get();
        long bindRequests = this.numBindRequests.get();
        long bindResponses = this.numBindResponses.get();
        long bindTimes = this.totalBindResponseTime.get();
        long compareRequests = this.numCompareRequests.get();
        long compareResponses = this.numCompareResponses.get();
        long compareTimes = this.totalCompareResponseTime.get();
        long deleteRequests = this.numDeleteRequests.get();
        long deleteResponses = this.numDeleteResponses.get();
        long deleteTimes = this.totalDeleteResponseTime.get();
        long extendedRequests = this.numExtendedRequests.get();
        long extendedResponses = this.numExtendedResponses.get();
        long extendedTimes = this.totalExtendedResponseTime.get();
        long modifyRequests = this.numModifyRequests.get();
        long modifyResponses = this.numModifyResponses.get();
        long modifyTimes = this.totalModifyResponseTime.get();
        long modifyDNRequests = this.numModifyDNRequests.get();
        long modifyDNResponses = this.numModifyDNResponses.get();
        long modifyDNTimes = this.totalModifyDNResponseTime.get();
        long searchRequests = this.numSearchRequests.get();
        long searchEntries = this.numSearchEntryResponses.get();
        long searchReferences = this.numSearchReferenceResponses.get();
        long searchDone = this.numSearchDoneResponses.get();
        long searchTimes = this.totalSearchResponseTime.get();
        long unbindRequests = this.numUnbindRequests.get();
        DecimalFormat f = new DecimalFormat("0.000");
        buffer.append("LDAPConnectionStatistics(numConnects=");
        buffer.append(connects);
        buffer.append(", numDisconnects=");
        buffer.append(disconnects);
        buffer.append(", numAbandonRequests=");
        buffer.append(abandonRequests);
        buffer.append(", numAddRequests=");
        buffer.append(addRequests);
        buffer.append(", numAddResponses=");
        buffer.append(addResponses);
        buffer.append(", totalAddResponseTimeNanos=");
        buffer.append(addTimes);
        if (addTimes > 0L) {
            buffer.append(", averageAddResponseTimeNanos=");
            buffer.append(f.format(1.0 * (double)addResponses / (double)addTimes));
        }
        buffer.append(", numBindRequests=");
        buffer.append(bindRequests);
        buffer.append(", numBindResponses=");
        buffer.append(bindResponses);
        buffer.append(", totalBindResponseTimeNanos=");
        buffer.append(bindTimes);
        if (bindTimes > 0L) {
            buffer.append(", averageBindResponseTimeNanos=");
            buffer.append(f.format(1.0 * (double)bindResponses / (double)bindTimes));
        }
        buffer.append(", numCompareRequests=");
        buffer.append(compareRequests);
        buffer.append(", numCompareResponses=");
        buffer.append(compareResponses);
        buffer.append(", totalCompareResponseTimeNanos=");
        buffer.append(compareTimes);
        if (compareTimes > 0L) {
            buffer.append(", averageCompareResponseTimeNanos=");
            buffer.append(f.format(1.0 * (double)compareResponses / (double)compareTimes));
        }
        buffer.append(", numDeleteRequests=");
        buffer.append(deleteRequests);
        buffer.append(", numDeleteResponses=");
        buffer.append(deleteResponses);
        buffer.append(", totalDeleteResponseTimeNanos=");
        buffer.append(deleteTimes);
        if (deleteTimes > 0L) {
            buffer.append(", averageDeleteResponseTimeNanos=");
            buffer.append(f.format(1.0 * (double)deleteResponses / (double)deleteTimes));
        }
        buffer.append(", numExtendedRequests=");
        buffer.append(extendedRequests);
        buffer.append(", numExtendedResponses=");
        buffer.append(extendedResponses);
        buffer.append(", totalExtendedResponseTimeNanos=");
        buffer.append(extendedTimes);
        if (extendedTimes > 0L) {
            buffer.append(", averageExtendedResponseTimeNanos=");
            buffer.append(f.format(1.0 * (double)extendedResponses / (double)extendedTimes));
        }
        buffer.append(", numModifyRequests=");
        buffer.append(modifyRequests);
        buffer.append(", numModifyResponses=");
        buffer.append(modifyResponses);
        buffer.append(", totalModifyResponseTimeNanos=");
        buffer.append(modifyTimes);
        if (modifyTimes > 0L) {
            buffer.append(", averageModifyResponseTimeNanos=");
            buffer.append(f.format(1.0 * (double)modifyResponses / (double)modifyTimes));
        }
        buffer.append(", numModifyDNRequests=");
        buffer.append(modifyDNRequests);
        buffer.append(", numModifyDNResponses=");
        buffer.append(modifyDNResponses);
        buffer.append(", totalModifyDNResponseTimeNanos=");
        buffer.append(modifyDNTimes);
        if (modifyDNTimes > 0L) {
            buffer.append(", averageModifyDNResponseTimeNanos=");
            buffer.append(f.format(1.0 * (double)modifyDNResponses / (double)modifyDNTimes));
        }
        buffer.append(", numSearchRequests=");
        buffer.append(searchRequests);
        buffer.append(", numSearchEntries=");
        buffer.append(searchEntries);
        buffer.append(", numSearchReferences=");
        buffer.append(searchReferences);
        buffer.append(", numSearchDone=");
        buffer.append(searchDone);
        buffer.append(", totalSearchResponseTimeNanos=");
        buffer.append(searchTimes);
        if (searchTimes > 0L) {
            buffer.append(", averageSearchResponseTimeNanos=");
            buffer.append(f.format(1.0 * (double)searchDone / (double)searchTimes));
        }
        buffer.append(", numUnbindRequests=");
        buffer.append(unbindRequests);
        buffer.append(')');
    }
}

