/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.POP3StreamResponse;
import org.apache.james.protocols.pop3.core.AbstractPOP3CommandHandler;
import org.apache.james.protocols.pop3.core.CRLFTerminatedInputStream;
import org.apache.james.protocols.pop3.core.CapaCapability;
import org.apache.james.protocols.pop3.core.ExtraDotInputStream;
import org.apache.james.protocols.pop3.core.MDCConstants;
import org.apache.james.protocols.pop3.core.POP3MessageCommandArguments;
import org.apache.james.protocols.pop3.core.POP3MessageCommandDelegate;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;
import org.apache.james.util.MDCBuilder;

public class TopCmdHandler
extends AbstractPOP3CommandHandler
implements CapaCapability {
    private static final Collection<String> COMMANDS = ImmutableList.of((Object)"TOP");
    private static final Set<String> CAPS = ImmutableSet.of((Object)"TOP");
    private static final Response SYNTAX_ERROR = new POP3Response("-ERR", "Usage: TOP [mail number] [line count]").immutable();
    private final MetricFactory metricFactory;
    private final POP3MessageCommandDelegate commandDelegate;

    @Inject
    public TopCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
        this.commandDelegate = new POP3MessageCommandDelegate(COMMANDS){

            @Override
            protected Response handleMessageExists(POP3Session session, MessageMetaData data, POP3MessageCommandArguments args) throws IOException {
                if (args.getLineCount().isEmpty()) {
                    return this.handleSyntaxError();
                }
                InputStream content = TopCmdHandler.this.getMessageContent(session, data);
                CountingBodyInputStream in = new CountingBodyInputStream(new CRLFTerminatedInputStream(new ExtraDotInputStream(content)), args.getLineCount().get());
                return new POP3StreamResponse("+OK", "Message follows", in);
            }

            @Override
            protected Response handleSyntaxError() {
                return SYNTAX_ERROR;
            }
        };
    }

    @Override
    public Response onCommand(POP3Session session, Request request) {
        return (Response)this.metricFactory.decorateSupplierWithTimerMetric("pop3-top", () -> (Response)MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addToContext("action", "TOP").addToContext(MDCConstants.withSession(session)).addToContext(MDCConstants.forRequest(request)), () -> this.commandDelegate.handleMessageRequest(session, request)));
    }

    protected InputStream getMessageContent(POP3Session session, MessageMetaData data) throws IOException {
        return session.getUserMailbox().getMessage(data.getUid());
    }

    @Override
    public Set<String> getImplementedCapabilities(POP3Session session) {
        if (session.getHandlerState() == 2) {
            return CAPS;
        }
        return Collections.emptySet();
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    private static final class CountingBodyInputStream
    extends InputStream {
        private int count = 0;
        private int limit = -1;
        private int lastChar;
        private final InputStream in;
        private boolean isBody = false;
        private boolean isEmptyLine = false;

        public CountingBodyInputStream(InputStream in, int limit) {
            this.in = in;
            this.limit = limit;
        }

        @Override
        public int read() throws IOException {
            if (this.limit != -1) {
                if (this.count <= this.limit) {
                    int a = this.in.read();
                    if (!this.isBody && this.isEmptyLine && this.lastChar == 13 && a == 10) {
                        this.isBody = true;
                    }
                    if (this.lastChar == 13 && a == 10) {
                        this.isEmptyLine = true;
                        if (this.isBody) {
                            ++this.count;
                        }
                    } else if (this.lastChar == 10 && a != 13) {
                        this.isEmptyLine = false;
                    }
                    this.lastChar = a;
                    return a;
                }
                return -1;
            }
            return this.in.read();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public void mark(int readlimit) {
        }

        @Override
        public void reset() throws IOException {
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

