/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceList;
import org.apache.iotdb.db.storageengine.dataregion.utils.fileTimeIndexCache.FileTimeIndexCacheWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTimeIndexCacheRecorder {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTimeIndexCacheRecorder.class);
    private static final int VERSION = 0;
    protected static final String FILE_NAME = "FileTimeIndexCache_0";
    private final ScheduledExecutorService recordFileIndexThread;
    private final BlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue<Runnable>();
    private final Map<Integer, FileTimeIndexCacheWriter> writerMap = new ConcurrentHashMap<Integer, FileTimeIndexCacheWriter>();

    private FileTimeIndexCacheRecorder() {
        this.recordFileIndexThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.FILE_TIME_INDEX_RECORD.getName());
        ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.recordFileIndexThread, this::executeTasks, (long)100L, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.recordFileIndexThread, (Runnable)StorageEngine.getInstance().executeCompactFileTimeIndexCache(), (long)120000L, (long)120000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void executeTasks() {
        Runnable task;
        while ((task = (Runnable)this.taskQueue.poll()) != null) {
            this.recordFileIndexThread.submit(task);
        }
    }

    public void logFileTimeIndex(TsFileResource ... tsFileResources) {
        if (tsFileResources != null && tsFileResources.length > 0) {
            TsFileResource firstResource = tsFileResources[0];
            TsFileID tsFileID = firstResource.getTsFileID();
            int dataRegionId = tsFileID.regionId;
            File dataRegionSysDir = StorageEngine.getDataRegionSystemDir(firstResource.getDatabaseName(), firstResource.getDataRegionId());
            FileTimeIndexCacheWriter writer = this.getWriter(dataRegionId, dataRegionSysDir);
            boolean result = this.taskQueue.offer(() -> {
                try {
                    ByteBuffer buffer = ByteBuffer.allocate(TsFileResource.getFileTimeIndexSerializedSize() * tsFileResources.length);
                    for (TsFileResource tsFileResource : tsFileResources) {
                        tsFileResource.serializeFileTimeIndexToByteBuffer(buffer);
                    }
                    buffer.flip();
                    writer.write(buffer);
                }
                catch (IOException e) {
                    LOGGER.warn("Meet error when record FileTimeIndexCache: {}", (Object)e.getMessage());
                }
            });
            if (!result) {
                LOGGER.warn("Meet error when record FileTimeIndexCache");
            }
        }
    }

    public void compactFileTimeIndexIfNeeded(String dataBaseName, int dataRegionId, int currentResourceCount, Map<Long, TsFileResourceList> sequenceFiles, Map<Long, TsFileResourceList> unsequenceFiles) {
        boolean result;
        FileTimeIndexCacheWriter writer = this.getWriter(dataRegionId, StorageEngine.getDataRegionSystemDir(dataBaseName, String.valueOf(dataRegionId)));
        if (writer.getLogFile().length() > (long)(currentResourceCount * TsFileResource.getFileTimeIndexSerializedSize()) * 100L && !(result = this.taskQueue.offer(() -> {
            try {
                ByteBuffer buffer;
                writer.clearFile();
                for (TsFileResourceList sequenceList : sequenceFiles.values()) {
                    if (sequenceList == null || sequenceList.isEmpty()) continue;
                    buffer = ByteBuffer.allocate(TsFileResource.getFileTimeIndexSerializedSize() * sequenceList.size());
                    for (TsFileResource tsFileResource : sequenceList) {
                        tsFileResource.serializeFileTimeIndexToByteBuffer(buffer);
                    }
                    buffer.flip();
                    writer.write(buffer);
                }
                for (TsFileResourceList unsequenceList : unsequenceFiles.values()) {
                    if (unsequenceList == null || unsequenceList.isEmpty()) continue;
                    buffer = ByteBuffer.allocate(TsFileResource.getFileTimeIndexSerializedSize() * unsequenceList.size());
                    for (TsFileResource tsFileResource : unsequenceList) {
                        tsFileResource.serializeFileTimeIndexToByteBuffer(buffer);
                    }
                    buffer.flip();
                    writer.write(buffer);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Meet error when compact FileTimeIndexCache: {}", (Object)e.getMessage());
            }
        }))) {
            LOGGER.warn("Meet error when compact FileTimeIndexCache");
        }
    }

    private FileTimeIndexCacheWriter getWriter(int dataRegionId, File dataRegionSysDir) {
        return this.writerMap.computeIfAbsent(dataRegionId, k -> {
            File logFile = SystemFileFactory.INSTANCE.getFile(dataRegionSysDir, FILE_NAME);
            try {
                if (!dataRegionSysDir.exists() && !dataRegionSysDir.mkdirs()) {
                    LOGGER.debug("DataRegionSysDir has existed\uff0cfilePath:{}", (Object)dataRegionSysDir.getAbsolutePath());
                }
                if (!logFile.createNewFile()) {
                    LOGGER.debug("FileTimeIndex file has existed\uff0cfilePath:{}", (Object)logFile.getAbsolutePath());
                }
                return new FileTimeIndexCacheWriter(logFile, true);
            }
            catch (IOException e) {
                LOGGER.error("FileTimeIndex log file create filed\uff0cfilePath:{}", (Object)logFile.getAbsolutePath(), (Object)e);
                throw new RuntimeException(e);
            }
        });
    }

    public void close() throws IOException {
        for (FileTimeIndexCacheWriter writer : this.writerMap.values()) {
            writer.close();
        }
    }

    public void removeFileTimeIndexCache(int dataRegionId) {
        FileTimeIndexCacheWriter writer = this.writerMap.remove(dataRegionId);
        if (writer != null) {
            try {
                writer.close();
                FileUtils.deleteFileOrDirectory((File)writer.getLogFile(), (boolean)true);
            }
            catch (IOException e) {
                LOGGER.warn("Meet error when close FileTimeIndexCache: {}", (Object)e.getMessage());
            }
        }
    }

    public static FileTimeIndexCacheRecorder getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static class InstanceHolder {
        private static final FileTimeIndexCacheRecorder INSTANCE = new FileTimeIndexCacheRecorder();

        private InstanceHolder() {
        }
    }
}

