/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.List;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.BatchEncodeInfo;
import org.apache.iotdb.db.utils.datastructure.MultiAlignedTVListIterator;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.write.chunk.IChunkWriter;

public class OrderedMultiAlignedTVListIterator
extends MultiAlignedTVListIterator {
    private final BitMap bitMap = new BitMap(this.tsDataTypeList.size());
    private int iteratorIndex = 0;
    private int[] rowIndices;

    public OrderedMultiAlignedTVListIterator(List<TSDataType> tsDataTypes, List<Integer> columnIndexList, List<AlignedTVList> alignedTvLists, List<Integer> tvListRowCounts, Ordering scanOrder, Filter globalTimeFilter, List<List<TimeRange>> valueColumnsDeletionList, Integer floatPrecision, List<TSEncoding> encodingList, int maxNumberOfPointsInPage) {
        super(tsDataTypes, columnIndexList, alignedTvLists, tvListRowCounts, scanOrder, globalTimeFilter, valueColumnsDeletionList, floatPrecision, encodingList, maxNumberOfPointsInPage);
    }

    @Override
    protected void prepareNext() {
        this.hasNext = false;
        while (this.iteratorIndex < this.alignedTvListIterators.size() && !this.hasNext) {
            AlignedTVList.AlignedTVListIterator iterator = (AlignedTVList.AlignedTVListIterator)this.alignedTvListIterators.get(this.iteratorIndex);
            if (!iterator.hasNextTimeValuePair()) {
                ++this.iteratorIndex;
                continue;
            }
            this.bitMap.reset();
            this.rowIndices = iterator.getSelectedIndices();
            this.currentTime = iterator.currentTime();
            this.hasNext = true;
            for (int columnIndex = 0; columnIndex < this.tsDataTypeList.size(); ++columnIndex) {
                if ((this.valueColumnsDeletionList == null || !ModificationUtils.isPointDeleted(this.currentTime, (List)this.valueColumnsDeletionList.get(columnIndex), (int[])this.valueColumnDeleteCursor.get(columnIndex), this.scanOrder)) && !iterator.isNullValue(this.rowIndices[columnIndex], columnIndex)) continue;
                this.bitMap.mark(columnIndex);
            }
            if (!this.bitMap.isAllMarked()) continue;
            iterator.next();
            this.hasNext = false;
        }
        this.probeNext = true;
    }

    @Override
    protected void skipToCurrentTimeRangeStartPosition() {
        this.hasNext = false;
        this.iteratorIndex = 0;
        while (this.iteratorIndex < this.alignedTvListIterators.size() && !this.hasNext) {
            AlignedTVList.AlignedTVListIterator iterator = (AlignedTVList.AlignedTVListIterator)this.alignedTvListIterators.get(this.iteratorIndex);
            iterator.skipToCurrentTimeRangeStartPosition();
            if (!iterator.hasNextTimeValuePair()) {
                ++this.iteratorIndex;
                continue;
            }
            this.hasNext = iterator.hasNextTimeValuePair();
        }
        this.probeNext = false;
    }

    @Override
    protected void next() {
        TVList.TVListIterator iterator = (TVList.TVListIterator)this.alignedTvListIterators.get(this.iteratorIndex);
        iterator.next();
        this.rowIndices = null;
        this.probeNext = false;
    }

    @Override
    public void encodeBatch(IChunkWriter chunkWriter, BatchEncodeInfo encodeInfo, long[] times) {
        while (this.iteratorIndex < this.alignedTvListIterators.size()) {
            TVList.TVListIterator iterator = (TVList.TVListIterator)this.alignedTvListIterators.get(this.iteratorIndex);
            if (!iterator.hasNextBatch()) {
                ++this.iteratorIndex;
                continue;
            }
            iterator.encodeBatch(chunkWriter, encodeInfo, times);
            break;
        }
        this.probeNext = false;
    }

    @Override
    protected int currentIteratorIndex(int columnIndex) {
        return this.iteratorIndex;
    }

    @Override
    protected int currentRowIndex(int columnIndex) {
        return this.rowIndices[columnIndex];
    }

    @Override
    public void setCurrentPageTimeRange(TimeRange timeRange) {
        for (AlignedTVList.AlignedTVListIterator iterator : this.alignedTvListIterators) {
            iterator.timeRange = timeRange;
        }
        super.setCurrentPageTimeRange(timeRange);
    }
}

