/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.sql.help;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.commands.sql.help.IgniteSqlCommand;
import org.apache.ignite.internal.cli.core.exception.IgniteCliException;
import picocli.CommandLine;

@CommandLine.Command(name="help", header={"Display help information about the specified SQL command."}, helpCommand=true, description={"%nWhen no SQL command is given, the usage help for the main command is displayed.", "If a SQL command is specified, the help for that command is shown.%n"}, descriptionHeading="%nDESCRIPTION%n", optionListHeading="%nOPTIONS @|fg(246) * - required option|@ %n", synopsisHeading="%nUSAGE%n", requiredOptionMarker=42, usageHelpAutoWidth=true, sortOptions=false, sortSynopsis=false, abbreviateSynopsis=true, commandListHeading="%nCOMMANDS%n", parameterListHeading="%nPARAMETERS @|fg(246) * - required parameter|@ %n")
public final class SqlHelpCommand
implements CommandLine.IHelpCommandInitializable2,
Runnable {
    @CommandLine.Parameters(paramLabel="Ignite SQL command", arity="0..2", description={"The SQL command to display the usage help message for."})
    private String[] parameters;
    private CommandLine self;
    private PrintWriter outWriter;
    private CommandLine.Help.ColorScheme colorScheme;

    @Override
    public void run() {
        if (this.parameters != null) {
            String command = String.join((CharSequence)" ", this.parameters);
            String commandUsage = IgniteSqlCommand.find(command).map(IgniteSqlCommand::getSyntax).or(() -> Optional.ofNullable(this.self.getParent()).map(it -> ((CommandLine)it.getSubcommands().get(command)).getUsageMessage())).orElseThrow(() -> new IgniteCliException("Unknown command: " + command));
            this.outWriter.println(commandUsage);
        } else {
            String helpMessage = this.self.getParent().getUsageMessage(this.colorScheme) + System.lineSeparator() + this.sqlCommands() + System.lineSeparator() + System.lineSeparator() + "Press Ctrl-D to exit.";
            this.outWriter.println(helpMessage);
        }
    }

    private String sqlCommands() {
        HashSet<String> topicsSet = new HashSet<String>();
        ArrayList<String> topics = new ArrayList<String>();
        for (IgniteSqlCommand command : IgniteSqlCommand.values()) {
            if (!topicsSet.add(command.getTopic().toLowerCase())) continue;
            topics.add(this.colorScheme.commandText("  " + command.getTopic()).toString());
        }
        return topics.stream().collect(Collectors.joining(System.lineSeparator(), "SQL commands" + System.lineSeparator(), ""));
    }

    public void init(CommandLine helpCommandLine, CommandLine.Help.ColorScheme colorScheme, PrintWriter out, PrintWriter err) {
        this.self = Objects.requireNonNull(helpCommandLine, "helpCommandLine");
        this.colorScheme = Objects.requireNonNull(colorScheme, "colorScheme");
        this.outWriter = Objects.requireNonNull(out, "outWriter");
        Objects.requireNonNull(err, "errWriter");
    }
}

