/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.call.configuration.JsonString;
import org.apache.ignite.internal.cli.config.CliConfigKeys;
import org.apache.ignite.internal.cli.config.ConfigManagerProvider;
import org.apache.ignite.internal.cli.core.decorator.Decorator;
import org.apache.ignite.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite.internal.cli.decorators.HoconDecorator;
import org.apache.ignite.internal.cli.decorators.JsonDecorator;
import picocli.CommandLine;

public class FormatMixin {
    @CommandLine.Option(names={"--format"}, description={"Output format. Valid values: ${COMPLETION-CANDIDATES}"}, defaultValue="HOCON", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private Format format;
    @Inject
    private ConfigManagerProvider configManagerProvider;

    public Decorator<JsonString, TerminalOutput> decorator() {
        if (this.format == Format.JSON) {
            return new JsonDecorator(this.isHighlightEnabled());
        }
        return new HoconDecorator(this.isHighlightEnabled());
    }

    private boolean isHighlightEnabled() {
        return Boolean.parseBoolean(this.configManagerProvider.get().getCurrentProperty(CliConfigKeys.SYNTAX_HIGHLIGHTING.value()));
    }

    private static enum Format {
        JSON,
        HOCON;

    }
}

