/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.table;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.jetbrains.annotations.Nullable;

public class QualifiedName {
    public static final String DEFAULT_SCHEMA_NAME = "PUBLIC";
    private final String schemaIdentifier;
    private final String objectIdentifier;

    public static QualifiedName parse(String simpleOrCanonicalName) {
        QualifiedName.verifyObjectIdentifier(simpleOrCanonicalName);
        Tokenizer tokenizer = new Tokenizer(simpleOrCanonicalName);
        String schemaName = DEFAULT_SCHEMA_NAME;
        String objectName = tokenizer.nextToken();
        if (tokenizer.hasNext()) {
            schemaName = objectName;
            objectName = tokenizer.nextToken();
        }
        if (tokenizer.hasNext()) {
            throw new IllegalArgumentException("Canonical name format mismatch: " + simpleOrCanonicalName);
        }
        QualifiedName.verifySchemaIdentifier(schemaName);
        QualifiedName.verifyObjectIdentifier(objectName);
        return new QualifiedName(schemaName, objectName);
    }

    public static QualifiedName fromSimple(String simpleName) {
        return QualifiedName.of(null, simpleName);
    }

    public static QualifiedName of(@Nullable String schemaName, String objectName) {
        String schemaIdentifier = schemaName == null ? DEFAULT_SCHEMA_NAME : QualifiedName.parseIdentifier(schemaName);
        String objectIdentifier = QualifiedName.parseIdentifier(objectName);
        QualifiedName.verifySchemaIdentifier(schemaIdentifier);
        QualifiedName.verifyObjectIdentifier(objectIdentifier);
        return new QualifiedName(schemaIdentifier, objectIdentifier);
    }

    private QualifiedName(String schemaName, String objectName) {
        this.schemaIdentifier = schemaName;
        this.objectIdentifier = objectName;
    }

    public String schemaName() {
        return this.schemaIdentifier;
    }

    public String objectName() {
        return this.objectIdentifier;
    }

    public String toCanonicalForm() {
        return QualifiedName.quoteIfNeeded(this.schemaIdentifier) + "." + QualifiedName.quoteIfNeeded(this.objectIdentifier);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)object;
        return Objects.equals(this.schemaIdentifier, that.schemaIdentifier) && Objects.equals(this.objectIdentifier, that.objectIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.schemaIdentifier, this.objectIdentifier);
    }

    public String toString() {
        return "QualifiedName[schemaName='" + this.schemaIdentifier + "', objectName='" + this.objectIdentifier + "']";
    }

    private static void verifyObjectIdentifier(@Nullable String identifier) {
        Objects.requireNonNull(identifier);
        if (identifier.isEmpty()) {
            throw new IllegalArgumentException("Object identifier can't be empty.");
        }
    }

    private static void verifySchemaIdentifier(@Nullable String identifier) {
        if (identifier != null && identifier.isEmpty()) {
            throw new IllegalArgumentException("Schema identifier can't be empty.");
        }
    }

    private static String parseIdentifier(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        Tokenizer tokenizer = new Tokenizer(name);
        String parsedName = tokenizer.nextToken();
        if (tokenizer.hasNext()) {
            throw new IllegalArgumentException("Fully qualified name is not expected [name=" + name + "]");
        }
        return parsedName;
    }

    private static String quoteIfNeeded(String identifier) {
        if (identifier.isEmpty()) {
            return identifier;
        }
        if (!IgniteNameUtils.identifierStart(identifier.codePointAt(0)) && !Character.isUpperCase(identifier.codePointAt(0))) {
            return IgniteNameUtils.quote(identifier);
        }
        for (int pos = 1; pos < identifier.length(); ++pos) {
            int codePoint = identifier.codePointAt(pos);
            if (IgniteNameUtils.identifierExtend(codePoint) || Character.isUpperCase(codePoint)) continue;
            return IgniteNameUtils.quote(identifier);
        }
        return identifier;
    }

    static class Tokenizer {
        private final String source;
        private int currentPosition;
        private boolean foundDot;

        public Tokenizer(String source) {
            this.source = source;
        }

        public boolean hasNext() {
            return this.foundDot || !this.isEol();
        }

        public String nextToken() {
            boolean quoted;
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more tokens available.");
            }
            if (this.isEol()) {
                assert (this.foundDot);
                this.foundDot = false;
                return "";
            }
            boolean bl = quoted = this.currentChar() == '\"';
            if (quoted) {
                ++this.currentPosition;
            }
            int start = this.currentPosition;
            StringBuilder sb = new StringBuilder();
            this.foundDot = false;
            if (!quoted && !this.isEol()) {
                if (IgniteNameUtils.identifierStart(this.source.codePointAt(this.currentPosition))) {
                    ++this.currentPosition;
                } else {
                    this.throwMalformedNameException();
                }
            }
            while (!this.isEol()) {
                char c = this.currentChar();
                if (c == '\"') {
                    if (!quoted) {
                        this.throwMalformedNameException();
                    }
                    if (this.hasNextChar() && this.nextChar() == '\"') {
                        sb.append(this.source, start, this.currentPosition + 1);
                        start = this.currentPosition + 2;
                        ++this.currentPosition;
                    } else {
                        if (!this.hasNextChar() || this.nextChar() == '.') {
                            sb.append(this.source, start, this.currentPosition);
                            this.foundDot = this.hasNextChar();
                            this.currentPosition += 2;
                            return sb.toString();
                        }
                        this.throwMalformedNameException();
                    }
                } else if (c == '.') {
                    if (!quoted) {
                        sb.append(this.source, start, this.currentPosition);
                        ++this.currentPosition;
                        this.foundDot = true;
                        return sb.toString().toUpperCase();
                    }
                } else if (!(quoted || IgniteNameUtils.identifierStart(this.source.codePointAt(this.currentPosition)) || IgniteNameUtils.identifierExtend(this.source.codePointAt(this.currentPosition)))) {
                    this.throwMalformedNameException();
                }
                ++this.currentPosition;
            }
            if (quoted) {
                this.throwMalformedNameException();
            }
            return this.source.substring(start).toUpperCase();
        }

        private boolean isEol() {
            return this.currentPosition >= this.source.length();
        }

        private char currentChar() {
            return this.source.charAt(this.currentPosition);
        }

        private boolean hasNextChar() {
            return this.currentPosition + 1 < this.source.length();
        }

        private char nextChar() {
            return this.source.charAt(this.currentPosition + 1);
        }

        private void throwMalformedNameException() {
            throw new IllegalArgumentException("Malformed identifier [identifier=" + this.source + ", pos=" + this.currentPosition + "]");
        }
    }
}

