/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nodestart;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.nodestart.IgniteRemoteStartSpecification;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class IgniteNodeStartUtils {
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String UNAME = "uname";
    public static final String PASSWD = "passwd";
    public static final String KEY = "key";
    public static final String NODES = "nodes";
    public static final String IGNITE_HOME = "igniteHome";
    public static final String CFG = "cfg";
    public static final String SCRIPT = "script";
    public static final String LOGGER = "logger";
    public static final int DFLT_TIMEOUT = 10000;
    public static final int DFLT_MAX_CONN = 5;
    private static final String RANGE_SMB = "~";
    private static final int DFLT_PORT = 22;
    private static final int DFLT_NODES = 1;
    private static final String DFLT_CFG = "";
    private static final String DFLT_SECTION = "defaults";

    private IgniteNodeStartUtils() {
    }

    public static IgniteBiTuple<Collection<Map<String, Object>>, Map<String, Object>> parseFile(File file) throws IgniteCheckedException {
        IgniteBiTuple<Collection<Map<String, Object>>, Map<String, Object>> igniteBiTuple;
        assert (file != null);
        assert (file.exists());
        assert (file.isFile());
        BufferedReader br = null;
        int lineCnt = 1;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String section = null;
            LinkedList<Map<String, Object>> hosts = new LinkedList<Map<String, Object>>();
            Map<String, Object> dflts = null;
            HashMap<String, Object> props = null;
            while ((line = br.readLine()) != null) {
                String l = line.trim();
                if (!(l.isEmpty() || l.startsWith("#") || l.startsWith(";"))) {
                    if (l.startsWith("[") && l.endsWith("]")) {
                        Map<String, Object> dfltsTmp = IgniteNodeStartUtils.processSection(section, hosts, dflts, props);
                        if (dfltsTmp != null) {
                            dflts = dfltsTmp;
                        }
                        props = new HashMap<String, Object>();
                        section = l.substring(1, l.length() - 1);
                    } else if (l.contains("=")) {
                        if (section == null) {
                            throw new IgniteCheckedException("Ignite ini format doesn't support unnamed section.");
                        }
                        String key = l.substring(0, l.indexOf(61));
                        String val = line.substring(line.indexOf(61) + 1);
                        switch (key) {
                            case "host": 
                            case "uname": 
                            case "passwd": 
                            case "igniteHome": 
                            case "cfg": 
                            case "script": {
                                props.put(key, val);
                                break;
                            }
                            case "port": 
                            case "nodes": {
                                props.put(key, Integer.valueOf(val));
                                break;
                            }
                            case "key": {
                                props.put(KEY, new File(val));
                            }
                        }
                    } else {
                        throw new IgniteCheckedException("Failed to parse INI file (line " + lineCnt + ").");
                    }
                }
                ++lineCnt;
            }
            Map<String, Object> dfltsTmp = IgniteNodeStartUtils.processSection(section, hosts, dflts, props);
            if (dfltsTmp != null) {
                dflts = dfltsTmp;
            }
            igniteBiTuple = F.t(hosts, dflts);
        }
        catch (IOException | NumberFormatException e) {
            try {
                throw new IgniteCheckedException("Failed to parse INI file (line " + lineCnt + ").", e);
            }
            catch (Throwable throwable) {
                U.closeQuiet(br);
                throw throwable;
            }
        }
        U.closeQuiet(br);
        return igniteBiTuple;
    }

    private static Map<String, Object> processSection(String section, Collection<Map<String, Object>> hosts, Map<String, Object> dflts, Map<String, Object> props) throws IgniteCheckedException {
        if (section == null || props == null) {
            return null;
        }
        if (DFLT_SECTION.equalsIgnoreCase(section)) {
            if (dflts != null) {
                throw new IgniteCheckedException("Only one 'defaults' section is allowed.");
            }
            return props;
        }
        hosts.add(props);
        return null;
    }

    public static Map<String, Collection<IgniteRemoteStartSpecification>> specifications(Collection<Map<String, Object>> hosts, @Nullable Map<String, Object> dflts) throws IgniteCheckedException {
        HashMap<String, Collection<IgniteRemoteStartSpecification>> specsMap = U.newHashMap(hosts.size());
        IgniteRemoteStartSpecification dfltSpec = IgniteNodeStartUtils.processDefaults(dflts);
        for (Map<String, Object> host : hosts) {
            Collection<IgniteRemoteStartSpecification> specs = IgniteNodeStartUtils.processHost(host, dfltSpec);
            for (IgniteRemoteStartSpecification spec : specs) {
                ((Collection)((Object)F.addIfAbsent(specsMap, spec.host(), new Callable<Collection<IgniteRemoteStartSpecification>>(){

                    @Override
                    public Collection<IgniteRemoteStartSpecification> call() throws Exception {
                        return new HashSet<IgniteRemoteStartSpecification>();
                    }
                }))).add(spec);
            }
        }
        return specsMap;
    }

    private static IgniteRemoteStartSpecification processDefaults(@Nullable Map<String, Object> dflts) throws IgniteCheckedException {
        int port = 22;
        String uname = System.getProperty("user.name");
        String passwd = null;
        File key = null;
        int nodes = 1;
        String igniteHome = null;
        String cfg = DFLT_CFG;
        String script = null;
        IgniteLogger log = null;
        if (dflts != null) {
            if (dflts.get(PORT) != null) {
                port = (Integer)dflts.get(PORT);
            }
            if (dflts.get(UNAME) != null) {
                uname = (String)dflts.get(UNAME);
            }
            if (dflts.get(PASSWD) != null) {
                passwd = (String)dflts.get(PASSWD);
            }
            if (dflts.get(KEY) != null) {
                key = (File)dflts.get(KEY);
            }
            if (dflts.get(NODES) != null) {
                nodes = (Integer)dflts.get(NODES);
            }
            if (dflts.get(IGNITE_HOME) != null) {
                igniteHome = (String)dflts.get(IGNITE_HOME);
            }
            if (dflts.get(CFG) != null) {
                cfg = (String)dflts.get(CFG);
            }
            if (dflts.get(SCRIPT) != null) {
                script = (String)dflts.get(SCRIPT);
            }
            if (dflts.get(LOGGER) != null) {
                log = (IgniteLogger)dflts.get(LOGGER);
            }
        }
        if (port <= 0) {
            throw new IgniteCheckedException("Invalid port number: " + port);
        }
        if (nodes <= 0) {
            throw new IgniteCheckedException("Invalid number of nodes: " + nodes);
        }
        return new IgniteRemoteStartSpecification(null, port, uname, passwd, key, nodes, igniteHome, cfg, script, log);
    }

    private static Collection<IgniteRemoteStartSpecification> processHost(Map<String, Object> props, IgniteRemoteStartSpecification dfltSpec) throws IgniteCheckedException {
        String script;
        assert (props != null);
        assert (dfltSpec != null);
        if (props.get(HOST) == null) {
            throw new IgniteCheckedException("Host must be specified.");
        }
        Set<String> hosts = IgniteNodeStartUtils.expandHost((String)props.get(HOST));
        int port = props.get(PORT) != null ? ((Integer)props.get(PORT)).intValue() : dfltSpec.port();
        String uname = props.get(UNAME) != null ? (String)props.get(UNAME) : dfltSpec.username();
        String passwd = props.get(PASSWD) != null ? (String)props.get(PASSWD) : dfltSpec.password();
        File key = props.get(KEY) != null ? (File)props.get(KEY) : dfltSpec.key();
        int nodes = props.get(NODES) != null ? ((Integer)props.get(NODES)).intValue() : dfltSpec.nodes();
        String igniteHome = props.get(IGNITE_HOME) != null ? (String)props.get(IGNITE_HOME) : dfltSpec.igniteHome();
        String cfg = props.get(CFG) != null ? (String)props.get(CFG) : dfltSpec.configuration();
        String string = script = props.get(SCRIPT) != null ? (String)props.get(SCRIPT) : dfltSpec.script();
        if (port <= 0) {
            throw new IgniteCheckedException("Invalid port number: " + port);
        }
        if (nodes <= 0) {
            throw new IgniteCheckedException("Invalid number of nodes: " + nodes);
        }
        if (passwd == null && key == null) {
            throw new IgniteCheckedException("Password or private key file must be specified.");
        }
        if (passwd != null && key != null) {
            passwd = null;
        }
        ArrayList<IgniteRemoteStartSpecification> specs = new ArrayList<IgniteRemoteStartSpecification>(hosts.size());
        for (String host : hosts) {
            specs.add(new IgniteRemoteStartSpecification(host, port, uname, passwd, key, nodes, igniteHome, cfg, script, dfltSpec.logger()));
        }
        return specs;
    }

    public static Set<String> expandHost(String addr) throws IgniteCheckedException {
        assert (addr != null);
        HashSet<String> addrs = new HashSet<String>();
        if (addr.contains(RANGE_SMB)) {
            String[] parts = addr.split(RANGE_SMB);
            if (parts.length != 2) {
                throw new IgniteCheckedException("Invalid IP range: " + addr);
            }
            int lastDot = parts[0].lastIndexOf(46);
            if (lastDot < 0) {
                throw new IgniteCheckedException("Invalid IP range: " + addr);
            }
            String base = parts[0].substring(0, lastDot);
            String begin = parts[0].substring(lastDot + 1);
            String end = parts[1];
            try {
                int a = Integer.valueOf(begin);
                int b = Integer.valueOf(end);
                if (a > b) {
                    throw new IgniteCheckedException("Invalid IP range: " + addr);
                }
                for (int i = a; i <= b; ++i) {
                    addrs.add(base + "." + i);
                }
            }
            catch (NumberFormatException e) {
                throw new IgniteCheckedException("Invalid IP range: " + addr, e);
            }
        } else {
            addrs.add(addr);
        }
        return addrs;
    }
}

