/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.warmup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.LoadAllWarmUpConfiguration;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.warmup.WarmUpStrategy;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class LoadAllWarmUpStrategy
implements WarmUpStrategy<LoadAllWarmUpConfiguration> {
    @GridToStringExclude
    private final IgniteLogger log;
    @GridToStringExclude
    private final Supplier<Collection<CacheGroupContext>> grpCtxSup;
    private volatile boolean stop;

    public LoadAllWarmUpStrategy(IgniteLogger log, Supplier<Collection<CacheGroupContext>> grpCtxSup) {
        this.log = log;
        this.grpCtxSup = grpCtxSup;
    }

    @Override
    public Class<LoadAllWarmUpConfiguration> configClass() {
        return LoadAllWarmUpConfiguration.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void warmUp(LoadAllWarmUpConfiguration cfg, DataRegion region) throws IgniteCheckedException {
        if (this.stop) {
            return;
        }
        assert (region.config().isPersistenceEnabled());
        Map<CacheGroupContext, List<LoadPartition>> loadDataInfo = this.loadDataInfo(region);
        long availableLoadPageCnt = this.availableLoadPageCount(region);
        if (this.log.isInfoEnabled()) {
            Collection<List<LoadPartition>> parts = loadDataInfo.values();
            this.log.info("Order of cache groups loaded into data region [name=" + region.config().getName() + ", partCnt=" + parts.stream().mapToLong(Collection::size).sum() + ", pageCnt=" + parts.stream().flatMap(Collection::stream).mapToLong(LoadPartition::pages).sum() + ", availablePageCnt=" + availableLoadPageCnt + ", grpNames=" + loadDataInfo.keySet().stream().map(CacheGroupContext::cacheOrGroupName).collect(Collectors.toList()) + "]");
        }
        long loadedPageCnt = 0L;
        for (Map.Entry<CacheGroupContext, List<LoadPartition>> e : loadDataInfo.entrySet()) {
            CacheGroupContext grp = e.getKey();
            List<LoadPartition> parts = e.getValue();
            if (this.log.isInfoEnabled()) {
                this.log.info("Start warm-up cache group, with estimated statistics [name=" + grp.cacheOrGroupName() + ", partCnt=" + parts.size() + ", pageCnt=" + parts.stream().mapToLong(LoadPartition::pages).sum() + "]");
            }
            PageMemoryEx pageMemEx = (PageMemoryEx)region.pageMemory();
            for (LoadPartition part : parts) {
                long pageId = pageMemEx.partitionMetaPageId(grp.groupId(), part.part());
                int i = 0;
                while ((long)i < part.pages()) {
                    if (this.stop) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Stop warm-up cache group with loaded statistics [name=" + grp.cacheOrGroupName() + ", pageCnt=" + loadedPageCnt + ", remainingPageCnt=" + (availableLoadPageCnt - loadedPageCnt) + "]");
                        }
                        return;
                    }
                    long pagePtr = -1L;
                    try {
                        pagePtr = pageMemEx.acquirePage(grp.groupId(), pageId);
                    }
                    finally {
                        if (pagePtr != -1L) {
                            pageMemEx.releasePage(grp.groupId(), pageId, pagePtr);
                        }
                    }
                    ++i;
                    ++pageId;
                    ++loadedPageCnt;
                }
            }
        }
    }

    @Override
    public void stop() throws IgniteCheckedException {
        this.stop = true;
    }

    public String toString() {
        return S.toString(LoadAllWarmUpStrategy.class, this);
    }

    protected long availableLoadPageCount(DataRegion region) {
        long maxSize = region.config().getMaxSize();
        long curSize = region.pageMemory().loadedPages() * (long)region.pageMemory().systemPageSize();
        return Math.max(0L, (maxSize - curSize) / (long)region.pageMemory().systemPageSize());
    }

    protected Map<CacheGroupContext, List<LoadPartition>> loadDataInfo(DataRegion region) throws IgniteCheckedException {
        List regionGrps = this.grpCtxSup.get().stream().filter(grpCtx -> region.equals(grpCtx.dataRegion())).collect(Collectors.toList());
        long availableLoadPageCnt = this.availableLoadPageCount(region);
        LinkedHashMap<CacheGroupContext, List<LoadPartition>> loadableGrps = new LinkedHashMap<CacheGroupContext, List<LoadPartition>>();
        for (int i = 0; i < regionGrps.size() && availableLoadPageCnt > 0L; ++i) {
            CacheGroupContext grp = (CacheGroupContext)regionGrps.get(i);
            List<GridDhtLocalPartition> locParts = grp.topology().localPartitions();
            for (int j = -1; j < locParts.size() && availableLoadPageCnt > 0L; ++j) {
                int p = j == -1 ? 65535 : locParts.get(j).id();
                long partPageCnt = grp.shared().pageStore().pages(grp.groupId(), p);
                if (partPageCnt <= 0L) continue;
                long pageCnt = availableLoadPageCnt - partPageCnt >= 0L ? partPageCnt : availableLoadPageCnt;
                availableLoadPageCnt -= pageCnt;
                loadableGrps.computeIfAbsent(grp, grpCtx -> new ArrayList()).add(new LoadPartition(p, pageCnt));
            }
        }
        return loadableGrps;
    }

    static class LoadPartition {
        private final int part;
        private final long pages;

        public LoadPartition(int part, long pages) {
            assert (part >= 0) : "Partition id cannot be negative.";
            assert (pages > 0L) : "Number of pages to load must be greater than zero.";
            this.part = part;
            this.pages = pages;
        }

        public int part() {
            return this.part;
        }

        public long pages() {
            return this.pages;
        }

        public String toString() {
            return S.toString(LoadPartition.class, this);
        }
    }
}

