/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.keys;

import java.sql.Date;
import java.time.LocalDate;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.DateValueUtils;
import org.apache.ignite.internal.cache.query.index.sorted.keys.DateTimeIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;

public class DateIndexKey
extends DateTimeIndexKey {
    private final long dateVal;

    public DateIndexKey(Object obj) {
        if (obj instanceof Date) {
            long millis = DateValueUtils.utcMillisFromDefaultTz(((Date)obj).getTime());
            this.dateVal = DateValueUtils.dateValueFromMillis(millis);
        } else if (obj instanceof LocalDate) {
            LocalDate locDate = (LocalDate)obj;
            this.dateVal = DateValueUtils.dateValue(locDate.getYear(), locDate.getMonthValue(), locDate.getDayOfMonth());
        } else {
            throw new IgniteException("Failed to convert object to date value, unexpected class " + obj.getClass().getName());
        }
    }

    public DateIndexKey(long dateVal) {
        this.dateVal = dateVal;
    }

    public long dateValue() {
        return this.dateVal;
    }

    @Override
    public IndexKeyType type() {
        return IndexKeyType.DATE;
    }

    @Override
    public Object key() {
        long millis = DateValueUtils.millisFromDateValue(this.dateVal);
        millis = DateValueUtils.defaultTzMillisFromUtc(millis);
        return new Date(millis);
    }

    @Override
    public int compareTo(long dateVal, long nanos) {
        return this.dateVal != dateVal ? Long.compare(this.dateVal, dateVal) : Long.compare(0L, nanos);
    }

    @Override
    public int compare(IndexKey o) {
        return -((DateTimeIndexKey)o).compareTo(this.dateVal, 0L);
    }

    public String toString() {
        return String.valueOf(this.dateVal);
    }
}

