/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.binary.BinaryArrayIdentityResolver;
import org.apache.ignite.internal.binary.BinaryPositionReadable;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriterSchemaHolder;
import org.apache.ignite.internal.binary.ObjectDetachHelper;
import org.apache.ignite.internal.binary.RawBinaryObjectExtractor;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;

public class CrossObjectReferenceResolver {
    private final RawBinaryObjectExtractor in;
    private final BinaryOutputStream out;
    private final int inRootObjStartPos;
    private final Map<Integer, Integer> objPosTranslation = new HashMap<Integer, Integer>();
    private final BinaryWriterSchemaHolder schema = new BinaryWriterSchemaHolder();

    private CrossObjectReferenceResolver(RawBinaryObjectExtractor in, BinaryOutputStream out) {
        this.in = in;
        this.inRootObjStartPos = in.position();
        this.out = out;
    }

    static void copyObject(RawBinaryObjectExtractor in, BinaryOutputStream out) {
        CrossObjectReferenceResolver resolver = new CrossObjectReferenceResolver(in, out);
        resolver.reassembleNextObject();
    }

    private void reassembleNextObject() {
        int inObjStartPos = this.in.position();
        int outObjStartPos = this.out.position();
        byte objType = this.in.readBytePositioned(inObjStartPos);
        switch (objType) {
            case 103: {
                this.doObjectProcessing();
                break;
            }
            case 102: {
                this.doHandleProcessing();
                break;
            }
            case 23: {
                this.objPosTranslation.put(inObjStartPos, outObjStartPos);
                this.copyBytes(1);
                this.in.copyTypeId(this.out);
                int size = this.copyInt();
                this.reassembleNextCortege(size);
                break;
            }
            case 24: {
                this.objPosTranslation.put(inObjStartPos, outObjStartPos);
                this.copyBytes(1);
                int size = this.copyInt();
                this.copyBytes(1);
                this.reassembleNextCortege(size);
                break;
            }
            case 25: {
                this.objPosTranslation.put(inObjStartPos, outObjStartPos);
                this.copyBytes(1);
                int size = this.copyInt() * 2;
                this.copyBytes(1);
                this.reassembleNextCortege(size);
                break;
            }
            default: {
                this.in.copyObject(this.out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doObjectProcessing() {
        int inObjStartPos = this.in.position();
        int outObjStartPos = this.out.position();
        this.objPosTranslation.put(inObjStartPos, outObjStartPos);
        BinaryObjectDescriptor inObjDesc = BinaryObjectDescriptor.parse(this.in, inObjStartPos);
        int fieldsCnt = 0;
        try {
            int footerFieldOffsetLen;
            int schemaOrRawOffsetPos;
            this.copyBytes(BinaryUtils.dataStartRelative(this.in, inObjStartPos));
            while (this.in.position() < inObjDesc.rawDataStartPos) {
                this.reassembleField(fieldsCnt++, this.offset(outObjStartPos, this.out.position()), inObjDesc);
            }
            int outRawDataStartPos = -1;
            if (inObjDesc.hasRaw) {
                outRawDataStartPos = this.out.position();
                this.copyBytes(inObjDesc.footerStartPos - this.in.position());
            }
            int outFooterStartPos = this.out.position();
            if (inObjDesc.hasSchema) {
                schemaOrRawOffsetPos = this.offset(outObjStartPos, outFooterStartPos);
                footerFieldOffsetLen = this.schema.write(this.out, fieldsCnt, inObjDesc.isCompactFooter);
                if (inObjDesc.hasRaw) {
                    this.out.writeInt(this.offset(outObjStartPos, outRawDataStartPos));
                }
            } else {
                schemaOrRawOffsetPos = inObjDesc.hasRaw ? this.offset(outObjStartPos, outRawDataStartPos) : 24;
                footerFieldOffsetLen = 0;
            }
            this.overrideHeader(outObjStartPos, this.setFieldOffsetFlag(inObjDesc.flags, footerFieldOffsetLen), BinaryArrayIdentityResolver.instance().hashCode(this.out.array(), outObjStartPos + 24, outFooterStartPos), this.out.position() - outObjStartPos, schemaOrRawOffsetPos);
            this.in.position(inObjDesc.endPos);
        }
        finally {
            this.schema.pop(fieldsCnt);
        }
    }

    private void doHandleProcessing() {
        int inObjStartPos = this.in.position();
        this.in.skipBytes(1);
        int offset = this.in.readInt();
        int inHandleObjPos = inObjStartPos - offset;
        Integer outHandleObjPos = this.objPosTranslation.get(inHandleObjPos);
        if (outHandleObjPos != null) {
            int outObjStartPos = this.out.position();
            this.out.writeByte((byte)102);
            this.out.writeInt(this.offset(outHandleObjPos, outObjStartPos));
        } else {
            assert (inHandleObjPos < this.inRootObjStartPos);
            this.objPosTranslation.put(inHandleObjPos, this.out.position());
            this.copyObjectPositioned(inHandleObjPos);
        }
    }

    private void overrideHeader(int writeObjStartPos, short flags, int hashCode, int totalLen, int schemaOrRawOffsetPos) {
        this.out.unsafeWriteShort(writeObjStartPos + 2, flags);
        this.out.unsafeWriteInt(writeObjStartPos + 8, hashCode);
        this.out.unsafeWriteInt(writeObjStartPos + 12, totalLen);
        this.out.unsafeWriteInt(writeObjStartPos + 20, schemaOrRawOffsetPos);
    }

    private short setFieldOffsetFlag(short flags, int fieldOffsetLength) {
        if (fieldOffsetLength == 0) {
            return flags;
        }
        flags = (short)(flags & 0xFFFFFFF7);
        flags = (short)(flags & 0xFFFFFFEF);
        if (fieldOffsetLength == 1) {
            flags = (short)(flags | 8);
        } else if (fieldOffsetLength == 2) {
            flags = (short)(flags | 0x10);
        }
        return flags;
    }

    private void reassembleField(int fieldOrder, int fieldOffset, BinaryObjectDescriptor binObjDesc) {
        int fieldId = binObjDesc.isCompactFooter ? -1 : this.in.readIntPositioned(binObjDesc.fieldIdPosition(fieldOrder));
        this.schema.push(fieldId, fieldOffset);
        this.reassembleNextObject();
    }

    private void reassembleNextCortege(int cortegeSize) {
        for (int elemIdx = 0; elemIdx < cortegeSize; ++elemIdx) {
            this.reassembleNextObject();
        }
    }

    private void copyObjectPositioned(int inPos) {
        int inRetPos = this.in.position();
        this.in.position(inPos);
        ObjectDetachHelper detachHelper = ObjectDetachHelper.create(this.in.array(), inPos);
        if (detachHelper.isCrossObjectReferencesDetected()) {
            detachHelper.detach(this.out);
        } else {
            this.in.copyObject(this.out);
        }
        this.in.position(inRetPos);
    }

    private int copyInt() {
        int res = this.in.peekInt();
        this.copyBytes(4);
        return res;
    }

    private void copyBytes(int cnt) {
        this.in.copyBytes(cnt, this.out);
    }

    private int offset(int startPos, int pos) {
        assert (pos - startPos >= 0);
        return pos - startPos;
    }

    private static class BinaryObjectDescriptor {
        private final int rawDataStartPos;
        private final int footerStartPos;
        private final int endPos;
        private final short flags;
        private final boolean hasRaw;
        private final boolean hasSchema;
        private final boolean isCompactFooter;
        private final int fieldOffsetLength;

        private BinaryObjectDescriptor(BinaryPositionReadable in, int startPos) {
            this.rawDataStartPos = BinaryUtils.rawOffsetAbsolute(in, startPos);
            this.footerStartPos = BinaryUtils.footerStartAbsolute(in, startPos);
            this.endPos = startPos + BinaryUtils.length(in, startPos);
            this.flags = in.readShortPositioned(startPos + 2);
            this.hasRaw = BinaryUtils.hasRaw(this.flags);
            this.hasSchema = BinaryUtils.hasSchema(this.flags);
            this.isCompactFooter = BinaryUtils.isCompactFooter(this.flags);
            this.fieldOffsetLength = BinaryUtils.fieldOffsetLength(this.flags);
        }

        private static BinaryObjectDescriptor parse(BinaryPositionReadable in, int startPos) {
            return new BinaryObjectDescriptor(in, startPos);
        }

        private int fieldIdPosition(int fieldOrder) {
            return this.footerStartPos + (4 + this.fieldOffsetLength) * fieldOrder;
        }
    }
}

