/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cdc;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cdc.CdcConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.cdc.CdcMain;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.util.spring.IgniteSpringHelper;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteExperimental;
import org.apache.ignite.lang.IgnitePredicate;

@IgniteExperimental
public class CdcLoader {
    public static CdcMain loadCdc(String springXmlPath) throws IgniteCheckedException {
        URL cfgUrl = U.resolveSpringUrl(springXmlPath);
        IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
        IgniteBiTuple<Map<Class<?>, Collection>, GridSpringResourceContext> cfgs = spring.loadBeans(cfgUrl, IgniteConfiguration.class, CdcConfiguration.class);
        Collection igniteCfgs = cfgs.get1().get(IgniteConfiguration.class);
        if (F.size(igniteCfgs, new IgnitePredicate[0]) != 1) {
            throw new IgniteCheckedException("Exact 1 IgniteConfiguration should be defined. Found " + F.size(igniteCfgs, new IgnitePredicate[0]));
        }
        Collection cdcCfgs = cfgs.get1().get(CdcConfiguration.class);
        if (F.size(cdcCfgs, new IgnitePredicate[0]) != 1) {
            throw new IgniteCheckedException("Exact 1 CaptureDataChangeConfiguration configuration should be defined. Found " + F.size(cdcCfgs, new IgnitePredicate[0]));
        }
        return new CdcMain((IgniteConfiguration)F.first(igniteCfgs), cfgs.get2(), (CdcConfiguration)F.first(cdcCfgs));
    }
}

