/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.spi.discovery.zk.internal.ZkRuntimeState;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoveryImpl;

abstract class ZkAbstractCallback {
    final ZkRuntimeState rtState;
    final ZookeeperDiscoveryImpl impl;
    private final GridSpinBusyLock busyLock;

    ZkAbstractCallback(ZkRuntimeState rtState, ZookeeperDiscoveryImpl impl) {
        this.rtState = rtState;
        this.impl = impl;
        this.busyLock = impl.busyLock;
    }

    final boolean onProcessStart() {
        boolean start;
        boolean bl = start = this.rtState.errForClose == null && this.busyLock.enterBusy();
        if (!start) {
            assert (this.rtState.errForClose != null);
            this.onStartFailed();
            return false;
        }
        return true;
    }

    void onStartFailed() {
    }

    final void onProcessEnd() {
        this.busyLock.leaveBusy();
    }

    final void onProcessError(Throwable e) {
        this.impl.onFatalError(this.busyLock, e);
    }
}

