/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.indexreader;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ignite.internal.commandline.indexreader.CacheAwareLink;
import org.apache.ignite.internal.commandline.indexreader.ItemStorage;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.util.collection.BitSetIntSet;
import org.apache.ignite.internal.util.collection.IntSet;
import org.jetbrains.annotations.NotNull;

class LinkStorage
implements ItemStorage<CacheAwareLink> {
    private final Map<Integer, Map<Integer, Map<Byte, IntSet>>> store = new HashMap<Integer, Map<Integer, Map<Byte, IntSet>>>();
    private long size;

    LinkStorage() {
    }

    @Override
    public void add(CacheAwareLink cacheAwareLink) {
        long link = cacheAwareLink.link;
        long pageId = PageIdUtils.pageId((long)link);
        this.store.computeIfAbsent(cacheAwareLink.cacheId, k -> new HashMap()).computeIfAbsent(PageIdUtils.partId((long)pageId), k -> new HashMap()).computeIfAbsent((byte)PageIdUtils.itemId((long)link), k -> new BitSetIntSet()).add(PageIdUtils.pageIndex((long)pageId));
        ++this.size;
    }

    @Override
    public boolean contains(CacheAwareLink cacheAwareLink) {
        IntSet set;
        Map<Byte, IntSet> innerMap;
        long link = cacheAwareLink.link;
        long pageId = PageIdUtils.pageId((long)link);
        Map<Integer, Map<Byte, IntSet>> map = this.store.get(cacheAwareLink.cacheId);
        if (map != null && (innerMap = map.get(PageIdUtils.partId((long)pageId))) != null && (set = innerMap.get((byte)PageIdUtils.itemId((long)link))) != null) {
            return set.contains(PageIdUtils.pageIndex((long)pageId));
        }
        return false;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    @NotNull
    public Iterator<CacheAwareLink> iterator() {
        throw new UnsupportedOperationException("Item iteration is not supported by link storage.");
    }
}

