/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.processors.query.calcite.hint.HintDefinition;
import org.apache.ignite.internal.processors.query.calcite.hint.HintUtils;
import org.apache.ignite.internal.processors.query.calcite.rule.AbstractIgniteConverterRule;
import org.apache.ignite.internal.util.typedef.F;

abstract class AbstractIgniteJoinConverterRule
extends AbstractIgniteConverterRule<LogicalJoin> {
    private static final EnumMap<HintDefinition, HintDefinition> HINTS = new EnumMap(HintDefinition.class);
    private static final HintDefinition[] ALL_HINTS;
    private final HintDefinition knownDisableHint;
    private final HintDefinition knownForceHint;

    protected AbstractIgniteJoinConverterRule(String descriptionPrefix, HintDefinition forceHint) {
        super(LogicalJoin.class, descriptionPrefix);
        assert (HINTS.containsKey((Object)forceHint));
        this.knownDisableHint = HINTS.get((Object)forceHint);
        this.knownForceHint = forceHint;
    }

    public final boolean matches(RelOptRuleCall call) {
        return super.matches(call) && this.matchesJoin(call) && !this.disabledByHints((LogicalJoin)call.rel(0));
    }

    private boolean disabledByHints(LogicalJoin join) {
        Collection<TableScan> joinTables = AbstractIgniteJoinConverterRule.joinTables((Join)join);
        ArrayList<RelHint> rawHints = new ArrayList<RelHint>();
        joinTables.forEach(t -> rawHints.addAll(HintUtils.nonInheritedRelHints((RelNode)t)));
        rawHints.addAll(HintUtils.allRelHints((RelNode)join));
        if (rawHints.isEmpty()) {
            return false;
        }
        boolean ruleDisabled = false;
        HashMap<String, Collection> hintedTables = new HashMap<String, Collection>();
        Set<String> joinTblNames = F.isEmpty(joinTables) ? Collections.emptySet() : joinTables.stream().map(t -> (String)Util.last((List)t.getTable().getQualifiedName())).collect(Collectors.toSet());
        for (RelHint hint : HintUtils.hints((RelNode)join, rawHints, ALL_HINTS)) {
            Set<String> matchedTbls;
            if (hint.listOptions.isEmpty()) {
                matchedTbls = joinTblNames;
            } else {
                matchedTbls = new HashSet<String>(hint.listOptions);
                matchedTbls.retainAll(joinTblNames);
                if (matchedTbls.isEmpty()) continue;
            }
            HintDefinition curHintDef = HintDefinition.valueOf(hint.hintName);
            boolean curHintIsDisable = !HINTS.containsKey((Object)curHintDef);
            boolean skipHint = false;
            for (String tbl : joinTblNames) {
                Collection prevTblHints = (Collection)hintedTables.get(tbl);
                if (prevTblHints == null) continue;
                HashSet<HintDefinition> allDisables = new HashSet<HintDefinition>();
                if (curHintIsDisable) {
                    allDisables.add(curHintDef);
                }
                for (HintDefinition prevTblHint : prevTblHints) {
                    boolean prevHintIsDisable;
                    boolean bl = prevHintIsDisable = !HINTS.containsKey((Object)prevTblHint);
                    if (prevHintIsDisable) {
                        allDisables.add(prevTblHint);
                    }
                    if ((!curHintIsDisable || allDisables.size() != HINTS.size()) && !AbstractIgniteJoinConverterRule.isMutuallyExclusive(curHintDef, prevTblHint)) continue;
                    skipHint = true;
                }
            }
            if (skipHint) {
                HintUtils.skippedHint((RelNode)join, hint, "This join type is already disabled or forced to use before by previous hints");
                continue;
            }
            for (String tbl : matchedTbls) {
                hintedTables.computeIfAbsent(tbl, t -> new ArrayList()).add(curHintDef);
            }
            if ((!curHintIsDisable || curHintDef != this.knownDisableHint) && (curHintIsDisable || this.knownForceHint == curHintDef)) continue;
            ruleDisabled = true;
        }
        return ruleDisabled;
    }

    private static boolean isMutuallyExclusive(HintDefinition curHint, HintDefinition prevHint) {
        if (curHint == prevHint) {
            return false;
        }
        HintDefinition curDisable = HINTS.get((Object)curHint);
        HintDefinition prevDisable = HINTS.get((Object)prevHint);
        return curDisable != null && prevDisable != null || curDisable == prevHint || curHint == prevDisable;
    }

    protected static Collection<TableScan> joinTables(Join join) {
        ArrayList<TableScan> res = new ArrayList<TableScan>(2);
        for (RelNode in : join.getInputs()) {
            if (in instanceof RelSubset) {
                in = ((RelSubset)in).getOriginal();
            }
            if (!(in instanceof TableScan)) continue;
            res.add((TableScan)in);
        }
        return res;
    }

    protected boolean matchesJoin(RelOptRuleCall call) {
        return true;
    }

    static {
        HINTS.put(HintDefinition.NL_JOIN, HintDefinition.NO_NL_JOIN);
        HINTS.put(HintDefinition.CNL_JOIN, HintDefinition.NO_CNL_JOIN);
        HINTS.put(HintDefinition.MERGE_JOIN, HintDefinition.NO_MERGE_JOIN);
        ALL_HINTS = (HintDefinition[])Stream.concat(HINTS.keySet().stream(), HINTS.values().stream()).toArray(HintDefinition[]::new);
    }
}

