/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.systemview;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.apache.ignite.internal.managers.systemview.AbstractSystemView;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.systemview.view.FiltrableSystemView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;
import org.jetbrains.annotations.NotNull;

public class FiltrableSystemViewAdapter<R, D>
extends AbstractSystemView<R>
implements FiltrableSystemView<R> {
    private Function<Map<String, Object>, Iterable<D>> dataSupplier;
    private final Function<D, R> rowFunc;

    public FiltrableSystemViewAdapter(String name, String desc, SystemViewRowAttributeWalker<R> walker, Function<Map<String, Object>, Iterable<D>> dataSupplier, Function<D, R> rowFunc) {
        super(name, desc, walker);
        A.notNull(dataSupplier, "dataSupplier");
        this.dataSupplier = dataSupplier;
        this.rowFunc = rowFunc;
    }

    @Override
    @NotNull
    public Iterator<R> iterator(Map<String, Object> filter) {
        if (filter == null) {
            filter = Collections.emptyMap();
        }
        return F.iterator(this.dataSupplier.apply(filter), this.rowFunc::apply, true, new IgnitePredicate[0]);
    }

    @Override
    @NotNull
    public Iterator<R> iterator() {
        return this.iterator(Collections.emptyMap());
    }

    @Override
    public int size() {
        return F.size(this.dataSupplier.apply(Collections.emptyMap()).iterator(), new IgnitePredicate[0]);
    }
}

