/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.obr.internal;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.felix.webconsole.plugins.obr.internal.AbstractBundleRepositoryRenderHelper;
import org.apache.felix.webconsole.plugins.obr.internal.FelixBundleRepositoryRenderHelper;
import org.apache.felix.webconsole.plugins.obr.internal.OsgiBundleRepositoryRenderHelper;
import org.apache.felix.webconsole.servlet.AbstractServlet;
import org.apache.felix.webconsole.servlet.RequestVariableResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

class WebConsolePlugin
extends AbstractServlet {
    private static final String LABEL = "obr";
    private static final String TITLE = "%obr.pluginTitle";
    private static final String CATEGORY = "OSGi";
    private static final String[] CSS = new String[]{"/obr/res/plugin.css"};
    private final String TEMPLATE;
    private AbstractBundleRepositoryRenderHelper helper;
    private ServiceRegistration<Servlet> registration;
    private BundleContext bundleContext;

    public WebConsolePlugin() {
        try {
            this.TEMPLATE = this.readTemplateFile("/res/plugin.html");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read template");
        }
    }

    public WebConsolePlugin register(BundleContext context) {
        this.bundleContext = context;
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("felix.webconsole.label", LABEL);
        ((Dictionary)props).put("felix.webconsole.title", TITLE);
        ((Dictionary)props).put("felix.webconsole.category", CATEGORY);
        ((Dictionary)props).put("felix.webconsole.css", CSS);
        this.registration = context.registerService(Servlet.class, (Object)this, props);
        return this;
    }

    public void deactivate() {
        if (this.registration != null) {
            try {
                this.registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.registration = null;
        }
        if (this.helper != null) {
            this.helper.dispose();
            this.helper = null;
        }
    }

    public void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestVariableResolver vars = this.getVariableResolver(request);
        vars.put((Object)"__data__", (Object)this.getData(request));
        response.getWriter().print(this.TEMPLATE);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.hasRepositoryAdmin()) {
            response.sendError(500, "RepositoryAdmin service is missing");
            return;
        }
        String action = request.getParameter("action");
        String deploy = request.getParameter("deploy");
        String deploystart = request.getParameter("deploystart");
        String optional = request.getParameter("optional");
        if (action != null) {
            this.doAction(action, request.getParameter("url"));
            response.getWriter().print(this.getData(request));
            return;
        }
        if (deploy != null || deploystart != null) {
            this.doDeploy(request.getParameterValues("bundle"), deploystart != null, optional != null);
            this.doGet(request, response);
            return;
        }
        super.doPost(request, response);
    }

    AbstractBundleRepositoryRenderHelper getHelper() {
        if (this.helper == null) {
            try {
                this.helper = new FelixBundleRepositoryRenderHelper(this.bundleContext);
            }
            catch (Throwable felixt) {
                try {
                    this.helper = new OsgiBundleRepositoryRenderHelper(this.bundleContext);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return this.helper;
    }

    private boolean hasRepositoryAdmin() {
        AbstractBundleRepositoryRenderHelper helper = this.getHelper();
        return helper != null && helper.hasRepositoryAdmin();
    }

    private String getData(HttpServletRequest request) {
        Object filter;
        AbstractBundleRepositoryRenderHelper helper = this.getHelper();
        if (helper == null || !helper.hasRepositoryAdmin()) {
            return "{}";
        }
        RequestInfo info = new RequestInfo(request);
        String list = info.getList();
        if (list != null) {
            if ("-".equals(list)) {
                StringBuffer sb = new StringBuffer("(!(|");
                for (int c = 0; c < 26; ++c) {
                    sb.append("(presentationname=").append((char)(97 + c)).append("*)(presentationname=").append((char)(65 + c)).append("*)");
                }
                sb.append("))");
                filter = sb.toString();
            } else {
                filter = "(|(presentationname=" + list.toLowerCase() + "*)(presentationname=" + list.toUpperCase() + "*))";
            }
        } else {
            String query = info.getQuery();
            if (query != null) {
                filter = query.indexOf(61) > 0 ? (query.startsWith("(") ? query : "(" + query + ")") : "(|(presentationame=*" + query + "*)(symbolicname=*" + query + "*))";
            } else {
                StringBuffer sb = new StringBuffer("(&");
                Enumeration e = request.getParameterNames();
                while (e.hasMoreElements()) {
                    String k = (String)e.nextElement();
                    String v = request.getParameter(k);
                    if (v == null || v.length() <= 0 || "details".equals(k) || "deploy".equals(k) || "deploystart".equals(k) || "bundle".equals(k) || "optional".equals(k)) continue;
                    sb.append('(').append(k).append('=').append(v).append(')');
                }
                sb.append(')');
                filter = sb.length() > 3 ? sb.toString() : null;
            }
        }
        return helper.getData((String)filter, info.showDetails(), this.bundleContext.getBundles());
    }

    private void doAction(String action, String urlParam) throws IOException, ServletException {
        AbstractBundleRepositoryRenderHelper helper = this.getHelper();
        if (helper != null) {
            helper.doAction(action, urlParam);
        }
    }

    private void doDeploy(String[] bundles, boolean start, boolean optional) {
        AbstractBundleRepositoryRenderHelper helper = this.getHelper();
        if (helper != null) {
            helper.doDeploy(bundles, start, optional);
        }
    }

    private static class RequestInfo {
        private final HttpServletRequest request;
        private boolean details;
        private String query;
        private String list;

        RequestInfo(HttpServletRequest request) {
            this.request = request;
        }

        boolean showDetails() {
            this.getQuery();
            return this.details;
        }

        String getQuery() {
            if (this.query == null) {
                Object query = this.request.getParameter("query");
                boolean details = false;
                if (query == null && this.request.getPathInfo().length() > 5) {
                    String path = this.request.getPathInfo().substring(5);
                    int slash = path.indexOf(47);
                    if (slash < 0) {
                        query = "(symbolicname=" + path + ")";
                    } else {
                        query = "(&(symbolicname=" + path.substring(0, slash) + ")(version=" + path.substring(slash + 1) + "))";
                        details = true;
                    }
                }
                this.query = query;
                this.details = details;
            }
            return this.query;
        }

        String getList() {
            if (this.list == null) {
                this.list = this.request.getParameter("list");
                if (this.list == null && !this.request.getParameterNames().hasMoreElements() && this.getQuery() == null) {
                    this.list = "a";
                }
            }
            return this.list;
        }
    }
}

