/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.systemready.impl;

import org.apache.felix.systemready.CheckStatus;
import org.apache.felix.systemready.StateType;
import org.apache.felix.systemready.SystemReadyCheck;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.felix.systemready.impl.FrameworkStartCheck", immediate=true, configurationPolicy=ConfigurationPolicy.OPTIONAL)
@Designate(ocd=Config.class)
public class FrameworkStartCheck
implements SystemReadyCheck {
    public static final String PID = "org.apache.felix.systemready.impl.FrameworkStartCheck";
    public static final String FRAMEWORK_STARTED = "Framework started. ";
    public static final String FRAMEWORK_NOT_STARTED = "Framework NOT started. ";
    public static final String FRAMEWORK_START_CHECK_NAME = "Framework Start Ready Check";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private BundleContext bundleContext;
    private long targetStartLevel;
    private StateType type;

    @Activate
    protected void activate(BundleContext ctx, Config config) throws InterruptedException {
        this.bundleContext = ctx;
        this.targetStartLevel = this.getTargetStartLevel(config);
        this.type = config.type();
        this.log.info("Activated");
    }

    private long getTargetStartLevel(Config config) {
        FrameworkStartLevel fsl = (FrameworkStartLevel)this.bundleContext.getBundle(0L).adapt(FrameworkStartLevel.class);
        long initial = fsl.getInitialBundleStartLevel();
        long tStartLevel = config.target_start_level() > 0 ? (long)config.target_start_level() : initial;
        String targetStartLevelKey = config.target_start_level_prop_name();
        if (null != targetStartLevelKey && !targetStartLevelKey.trim().isEmpty()) {
            try {
                tStartLevel = Long.valueOf(this.bundleContext.getProperty(targetStartLevelKey));
            }
            catch (NumberFormatException e) {
                this.log.info("Ignoring {} as it can't be parsed: {}", (Object)targetStartLevelKey, (Object)e.getMessage());
            }
        }
        return tStartLevel;
    }

    @Override
    public String getName() {
        return FRAMEWORK_START_CHECK_NAME;
    }

    @Override
    public CheckStatus getStatus() {
        boolean started;
        Bundle systemBundle = this.bundleContext.getBundle(0L);
        FrameworkStartLevel fsl = (FrameworkStartLevel)systemBundle.adapt(FrameworkStartLevel.class);
        String message = String.format("Start level: %d; Target start level: %d; Framework state: %d", fsl.getStartLevel(), this.targetStartLevel, fsl.getBundle().getState());
        boolean bl = started = systemBundle.getState() == 32 && (long)fsl.getStartLevel() >= this.targetStartLevel;
        if (started) {
            return new CheckStatus(this.getName(), this.type, CheckStatus.State.GREEN, FRAMEWORK_STARTED + message);
        }
        return new CheckStatus(this.getName(), this.type, CheckStatus.State.YELLOW, FRAMEWORK_NOT_STARTED + message);
    }

    @ObjectClassDefinition(name="Framework Start Ready Check", description="System ready that waits for the system bundle to be active")
    public static @interface Config {
        @AttributeDefinition(name="Timeout (seconds)", description="Number of seconds after which this is considered a failure")
        public long timeout() default 1000L;

        @AttributeDefinition(name="Target start level", description="The target start level at which the Framework is considered started. If zero or negative, it will default to the default bundle start level")
        public int target_start_level() default 0;

        @AttributeDefinition(name="Target start level OSGi property name", description="The name of the OSGi property which holds the \"Target start level\". It takes precedence over the target.start.level config. If the startlevel cannot be derived from the osgi property, this config attribute is ignored.")
        public String target_start_level_prop_name() default "";

        @AttributeDefinition(name="Check type")
        public StateType type() default StateType.ALIVE;
    }
}

