/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.impl;

import java.io.PrintStream;
import java.util.StringTokenizer;
import org.apache.felix.shell.Command;
import org.apache.felix.shell.impl.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

public class InspectCommandImpl
implements Command {
    public static final String PACKAGE_TYPE = "package";
    public static final String BUNDLE_TYPE = "bundle";
    public static final String FRAGMENT_TYPE = "fragment";
    public static final String SERVICE_TYPE = "service";
    public static final String CAPABILITY = "capability";
    public static final String REQUIREMENT = "requirement";
    private final BundleContext m_context;
    private ServiceReference m_ref = null;
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;

    public InspectCommandImpl(BundleContext context) {
        this.m_context = context;
    }

    public String getName() {
        return "inspect";
    }

    public String getUsage() {
        return "inspect (package|bundle|fragment|service) (capability|requirement) [<id> ...]";
    }

    public String getShortDescription() {
        return "inspects dependency information.";
    }

    public void execute(String s, PrintStream out, PrintStream err) {
        StringTokenizer st = new StringTokenizer(s, " ");
        st.nextToken();
        if (st.countTokens() < 2) {
            out.println("Too few arguments.");
            out.println(this.getUsage());
        } else {
            String type = st.nextToken();
            String direction = st.nextToken();
            String[] ids = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                ids[i] = st.nextToken().trim();
                ++i;
            }
            if (InspectCommandImpl.isValidType(type) && InspectCommandImpl.isValidDirection(direction)) {
                if (PACKAGE_TYPE.startsWith(type)) {
                    if (CAPABILITY.startsWith(direction)) {
                        this.printExportedPackages(ids, out, err);
                    } else {
                        this.printImportedPackages(ids, out, err);
                    }
                } else if (BUNDLE_TYPE.startsWith(type)) {
                    if (CAPABILITY.startsWith(direction)) {
                        this.printRequiringBundles(ids, out, err);
                    } else {
                        this.printRequiredBundles(ids, out, err);
                    }
                } else if (FRAGMENT_TYPE.startsWith(type)) {
                    if (CAPABILITY.startsWith(direction)) {
                        this.printFragmentHosts(ids, out, err);
                    } else {
                        this.printHostedFragments(ids, out, err);
                    }
                } else if (CAPABILITY.startsWith(direction)) {
                    this.printExportedServices(ids, out, err);
                } else {
                    this.printImportedServices(ids, out, err);
                }
            } else {
                if (!InspectCommandImpl.isValidType(type)) {
                    out.println("Invalid argument: " + type);
                }
                if (!InspectCommandImpl.isValidDirection(direction)) {
                    out.println("Invalid argument: " + direction);
                }
            }
        }
    }

    private void printExportedPackages(String[] ids, PrintStream out, PrintStream err) {
        PackageAdmin pa = this.getPackageAdmin();
        if (pa == null) {
            out.println("PackageAdmin service is unavailable.");
        } else {
            boolean separatorNeeded = false;
            Bundle[] bundles = null;
            if (ids == null || ids.length == 0) {
                bundles = this.m_context.getBundles();
            } else {
                bundles = new Bundle[ids.length];
                for (int idIdx = 0; idIdx < ids.length; ++idIdx) {
                    try {
                        long l = Long.parseLong(ids[idIdx]);
                        Bundle b = this.m_context.getBundle(l);
                        if (b == null) {
                            err.println("Bundle ID " + ids[idIdx] + " is invalid.");
                        }
                        bundles[idIdx] = b;
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        err.println("Unable to parse id '" + ids[idIdx] + "'.");
                    }
                }
            }
            for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
                try {
                    if (bundles[bundleIdx] == null) continue;
                    ExportedPackage[] exports = pa.getExportedPackages(bundles[bundleIdx]);
                    if (separatorNeeded) {
                        out.println("");
                    }
                    String title = bundles[bundleIdx] + " exports packages:";
                    out.println(title);
                    out.println(Util.getUnderlineString(title));
                    if (exports != null && exports.length > 0) {
                        for (int expIdx = 0; expIdx < exports.length; ++expIdx) {
                            out.println(exports[expIdx]);
                        }
                    } else {
                        out.println("Nothing");
                    }
                    separatorNeeded = true;
                    continue;
                }
                catch (Exception ex) {
                    err.println(ex.toString());
                }
            }
        }
        this.ungetPackageAdmin();
    }

    private void printImportedPackages(String[] ids, PrintStream out, PrintStream err) {
        boolean separatorNeeded = false;
        Bundle[] bundles = null;
        if (ids == null || ids.length == 0) {
            bundles = this.m_context.getBundles();
        } else {
            bundles = new Bundle[ids.length];
            for (int idIdx = 0; idIdx < ids.length; ++idIdx) {
                try {
                    long l = Long.parseLong(ids[idIdx]);
                    Bundle b = this.m_context.getBundle(l);
                    if (b == null) {
                        err.println("Bundle ID " + ids[idIdx] + " is invalid.");
                    }
                    bundles[idIdx] = b;
                    continue;
                }
                catch (NumberFormatException ex) {
                    err.println("Unable to parse id '" + ids[idIdx] + "'.");
                }
            }
        }
        for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
            try {
                if (bundles[bundleIdx] == null) continue;
                if (separatorNeeded) {
                    out.println("");
                }
                this._printImportedPackages(bundles[bundleIdx], out, err);
                separatorNeeded = true;
                continue;
            }
            catch (Exception ex) {
                err.println(ex.toString());
            }
        }
    }

    private void _printImportedPackages(Bundle bundle, PrintStream out, PrintStream err) {
        PackageAdmin pa = this.getPackageAdmin();
        if (pa == null) {
            out.println("PackageAdmin service is unavailable.");
        } else {
            ExportedPackage[] exports = pa.getExportedPackages((Bundle)null);
            String title = bundle + " imports packages:";
            out.println(title);
            out.println(Util.getUnderlineString(title));
            boolean found = false;
            for (int expIdx = 0; expIdx < exports.length; ++expIdx) {
                Bundle[] importers = exports[expIdx].getImportingBundles();
                for (int impIdx = 0; importers != null && impIdx < importers.length; ++impIdx) {
                    if (importers[impIdx] != bundle) continue;
                    out.println(exports[expIdx] + " -> " + exports[expIdx].getExportingBundle());
                    found = true;
                }
            }
            if (!found) {
                out.println("Nothing");
            }
            this.ungetPackageAdmin();
        }
    }

    private void printRequiringBundles(String[] ids, PrintStream out, PrintStream err) {
        PackageAdmin pa = this.getPackageAdmin();
        if (pa == null) {
            out.println("PackageAdmin service is unavailable.");
        } else {
            boolean separatorNeeded = false;
            Bundle[] bundles = null;
            if (ids == null || ids.length == 0) {
                bundles = this.m_context.getBundles();
            } else {
                bundles = new Bundle[ids.length];
                for (int idIdx = 0; idIdx < ids.length; ++idIdx) {
                    try {
                        long l = Long.parseLong(ids[idIdx]);
                        Bundle b = this.m_context.getBundle(l);
                        if (b == null) {
                            err.println("Bundle ID " + ids[idIdx] + " is invalid.");
                        }
                        bundles[idIdx] = b;
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        err.println("Unable to parse id '" + ids[idIdx] + "'.");
                    }
                }
            }
            for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
                try {
                    if (bundles[bundleIdx] == null) continue;
                    RequiredBundle[] rbs = pa.getRequiredBundles(bundles[bundleIdx].getSymbolicName());
                    for (int rbIdx = 0; rbs != null && rbIdx < rbs.length; ++rbIdx) {
                        if (rbs[rbIdx].getBundle() != bundles[bundleIdx]) continue;
                        if (separatorNeeded) {
                            out.println("");
                        }
                        String title = bundles[bundleIdx] + " is required by:";
                        out.println(title);
                        out.println(Util.getUnderlineString(title));
                        if (rbs[rbIdx].getRequiringBundles() != null && rbs[rbIdx].getRequiringBundles().length > 0) {
                            for (int reqIdx = 0; reqIdx < rbs[rbIdx].getRequiringBundles().length; ++reqIdx) {
                                out.println(rbs[rbIdx].getRequiringBundles()[reqIdx]);
                            }
                        } else {
                            out.println("Nothing");
                        }
                        separatorNeeded = true;
                    }
                    continue;
                }
                catch (Exception ex) {
                    err.println(ex.toString());
                }
            }
        }
    }

    private void printRequiredBundles(String[] ids, PrintStream out, PrintStream err) {
        boolean separatorNeeded = false;
        Bundle[] bundles = null;
        if (ids == null || ids.length == 0) {
            bundles = this.m_context.getBundles();
        } else {
            bundles = new Bundle[ids.length];
            for (int idIdx = 0; idIdx < ids.length; ++idIdx) {
                try {
                    long l = Long.parseLong(ids[idIdx]);
                    Bundle b = this.m_context.getBundle(l);
                    if (b == null) {
                        err.println("Bundle ID " + ids[idIdx] + " is invalid.");
                    }
                    bundles[idIdx] = b;
                    continue;
                }
                catch (NumberFormatException ex) {
                    err.println("Unable to parse id '" + ids[idIdx] + "'.");
                }
            }
        }
        for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
            try {
                if (bundles[bundleIdx] == null) continue;
                if (separatorNeeded) {
                    out.println("");
                }
                this._printRequiredBundles(bundles[bundleIdx], out, err);
                separatorNeeded = true;
                continue;
            }
            catch (Exception ex) {
                err.println(ex.toString());
            }
        }
    }

    private void _printRequiredBundles(Bundle bundle, PrintStream out, PrintStream err) {
        PackageAdmin pa = this.getPackageAdmin();
        if (pa == null) {
            out.println("PackageAdmin service is unavailable.");
        } else {
            RequiredBundle[] rbs = pa.getRequiredBundles(null);
            String title = bundle + " requires bundles:";
            out.println(title);
            out.println(Util.getUnderlineString(title));
            boolean found = false;
            for (int rbIdx = 0; rbIdx < rbs.length; ++rbIdx) {
                Bundle[] requirers = rbs[rbIdx].getRequiringBundles();
                for (int reqIdx = 0; requirers != null && reqIdx < requirers.length; ++reqIdx) {
                    if (requirers[reqIdx] != bundle) continue;
                    out.println(rbs[reqIdx]);
                    found = true;
                }
            }
            if (!found) {
                out.println("Nothing");
            }
            this.ungetPackageAdmin();
        }
    }

    private void printFragmentHosts(String[] ids, PrintStream out, PrintStream err) {
        PackageAdmin pa = this.getPackageAdmin();
        if (pa == null) {
            out.println("PackageAdmin service is unavailable.");
        } else {
            Bundle[] bundles = null;
            if (ids == null || ids.length == 0) {
                bundles = this.m_context.getBundles();
            } else {
                bundles = new Bundle[ids.length];
                for (int idIdx = 0; idIdx < ids.length; ++idIdx) {
                    try {
                        long l = Long.parseLong(ids[idIdx]);
                        Bundle b = this.m_context.getBundle(l);
                        if (b == null) {
                            err.println("Bundle ID " + ids[idIdx] + " is invalid.");
                        }
                        bundles[idIdx] = b;
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        err.println("Unable to parse id '" + ids[idIdx] + "'.");
                    }
                }
            }
            for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
                if (bundleIdx > 0) {
                    out.println("");
                }
                try {
                    if (bundles[bundleIdx] != null && InspectCommandImpl.isFragment(bundles[bundleIdx])) {
                        String title = bundles[bundleIdx] + " is attached to:";
                        out.println(title);
                        out.println(Util.getUnderlineString(title));
                        Bundle[] hosts = pa.getHosts(bundles[bundleIdx]);
                        for (int hostIdx = 0; hosts != null && hostIdx < hosts.length; ++hostIdx) {
                            out.println(hosts[hostIdx]);
                        }
                        if (hosts != null && hosts.length != 0) continue;
                        out.println("Nothing");
                        continue;
                    }
                    if (bundles[bundleIdx] == null || InspectCommandImpl.isFragment(bundles[bundleIdx])) continue;
                    out.println("Bundle " + bundles[bundleIdx] + " is not a fragment.");
                    continue;
                }
                catch (Exception ex) {
                    err.println(ex.toString());
                }
            }
        }
    }

    private void printHostedFragments(String[] ids, PrintStream out, PrintStream err) {
        PackageAdmin pa = this.getPackageAdmin();
        if (pa == null) {
            out.println("PackageAdmin service is unavailable.");
        } else {
            Bundle[] bundles = null;
            if (ids == null || ids.length == 0) {
                bundles = this.m_context.getBundles();
            } else {
                bundles = new Bundle[ids.length];
                for (int idIdx = 0; idIdx < ids.length; ++idIdx) {
                    try {
                        long l = Long.parseLong(ids[idIdx]);
                        Bundle b = this.m_context.getBundle(l);
                        if (b == null) {
                            err.println("Bundle ID " + ids[idIdx] + " is invalid.");
                        }
                        bundles[idIdx] = b;
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        err.println("Unable to parse id '" + ids[idIdx] + "'.");
                    }
                }
            }
            for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
                if (bundleIdx > 0) {
                    out.println("");
                }
                try {
                    if (bundles[bundleIdx] != null && !InspectCommandImpl.isFragment(bundles[bundleIdx])) {
                        String title = bundles[bundleIdx] + " hosts:";
                        out.println(title);
                        out.println(Util.getUnderlineString(title));
                        Bundle[] fragments = pa.getFragments(bundles[bundleIdx]);
                        for (int fragIdx = 0; fragments != null && fragIdx < fragments.length; ++fragIdx) {
                            out.println(fragments[fragIdx]);
                        }
                        if (fragments != null && fragments.length != 0) continue;
                        out.println("Nothing");
                        continue;
                    }
                    if (bundles[bundleIdx] == null || !InspectCommandImpl.isFragment(bundles[bundleIdx])) continue;
                    out.println("Bundle " + bundles[bundleIdx] + " is a fragment.");
                    continue;
                }
                catch (Exception ex) {
                    err.println(ex.toString());
                }
            }
        }
    }

    public void printExportedServices(String[] ids, PrintStream out, PrintStream err) {
        Bundle[] bundles = null;
        if (ids == null || ids.length == 0) {
            bundles = this.m_context.getBundles();
        } else {
            bundles = new Bundle[ids.length];
            for (int idIdx = 0; idIdx < ids.length; ++idIdx) {
                try {
                    long l = Long.parseLong(ids[idIdx]);
                    Bundle b = this.m_context.getBundle(l);
                    if (b == null) {
                        err.println("Bundle ID " + ids[idIdx] + " is invalid.");
                    }
                    bundles[idIdx] = b;
                    continue;
                }
                catch (NumberFormatException ex) {
                    err.println("Unable to parse id '" + ids[idIdx] + "'.");
                }
            }
        }
        for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
            if (bundleIdx > 0) {
                out.println("");
            }
            try {
                if (bundles[bundleIdx] == null) continue;
                ServiceReference[] refs = bundles[bundleIdx].getRegisteredServices();
                String title = Util.getBundleName(bundles[bundleIdx]) + " provides services:";
                out.println(title);
                out.println(Util.getUnderlineString(title));
                if (refs == null || refs.length == 0) {
                    out.println("Nothing");
                }
                for (int refIdx = 0; refs != null && refIdx < refs.length; ++refIdx) {
                    String[] keys = refs[refIdx].getPropertyKeys();
                    for (int keyIdx = 0; keys != null && keyIdx < keys.length; ++keyIdx) {
                        Object v = refs[refIdx].getProperty(keys[keyIdx]);
                        out.println(keys[keyIdx] + " = " + Util.getValueString(v));
                    }
                    if (refIdx + 1 >= refs.length) continue;
                    out.println("----");
                }
                continue;
            }
            catch (Exception ex) {
                err.println(ex.toString());
            }
        }
    }

    public void printImportedServices(String[] ids, PrintStream out, PrintStream err) {
        Bundle[] bundles = null;
        if (ids == null || ids.length == 0) {
            bundles = this.m_context.getBundles();
        } else {
            bundles = new Bundle[ids.length];
            for (int idIdx = 0; idIdx < ids.length; ++idIdx) {
                try {
                    long l = Long.parseLong(ids[idIdx]);
                    Bundle b = this.m_context.getBundle(l);
                    if (b == null) {
                        err.println("Bundle ID " + ids[idIdx] + " is invalid.");
                    }
                    bundles[idIdx] = b;
                    continue;
                }
                catch (NumberFormatException ex) {
                    err.println("Unable to parse id '" + ids[idIdx] + "'.");
                }
            }
        }
        for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
            if (bundleIdx > 0) {
                out.println("");
            }
            try {
                if (bundles[bundleIdx] == null) continue;
                ServiceReference[] refs = bundles[bundleIdx].getServicesInUse();
                String title = Util.getBundleName(bundles[bundleIdx]) + " requires services:";
                out.println(title);
                out.println(Util.getUnderlineString(title));
                if (refs == null || refs.length == 0) {
                    out.println("Nothing");
                }
                for (int refIdx = 0; refs != null && refIdx < refs.length; ++refIdx) {
                    out.println("Registering bundle = " + refs[refIdx].getBundle());
                    String[] keys = refs[refIdx].getPropertyKeys();
                    for (int keyIdx = 0; keys != null && keyIdx < keys.length; ++keyIdx) {
                        Object v = refs[refIdx].getProperty(keys[keyIdx]);
                        out.println(keys[keyIdx] + " = " + Util.getValueString(v));
                    }
                    if (refIdx + 1 >= refs.length) continue;
                    out.println("----");
                }
                continue;
            }
            catch (Exception ex) {
                err.println(ex.toString());
            }
        }
    }

    private PackageAdmin getPackageAdmin() {
        PackageAdmin pa = null;
        this.m_ref = this.m_context.getServiceReference((class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = InspectCommandImpl.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName());
        if (this.m_ref != null) {
            pa = (PackageAdmin)this.m_context.getService(this.m_ref);
        }
        return pa;
    }

    private void ungetPackageAdmin() {
        this.m_context.ungetService(this.m_ref);
    }

    private static boolean isValidType(String type) {
        return PACKAGE_TYPE.startsWith(type) || BUNDLE_TYPE.startsWith(type) || FRAGMENT_TYPE.startsWith(type) || SERVICE_TYPE.startsWith(type);
    }

    private static boolean isValidDirection(String direction) {
        return CAPABILITY.startsWith(direction) || REQUIREMENT.startsWith(direction);
    }

    private static boolean isFragment(Bundle bundle) {
        return bundle.getHeaders().get("Fragment-Host") != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

