/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.log;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.log.ConfigurationListenerImpl;
import org.apache.felix.log.Log;
import org.apache.felix.log.LogReaderServiceFactory;
import org.apache.felix.log.LogServiceFactory;
import org.apache.felix.log.LoggerAdminImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;
import org.osgi.service.log.LoggerFactory;
import org.osgi.service.log.admin.LoggerAdmin;

public final class Activator
implements BundleActivator {
    private static final String MAX_SIZE_PROPERTY = "org.apache.felix.log.maxSize";
    private static final int DEFAULT_MAX_SIZE = 100;
    private static final String STORE_DEBUG_PROPERTY = "org.apache.felix.log.storeDebug";
    private static final boolean DEFAULT_STORE_DEBUG = false;
    private Log m_log;
    private LoggerAdminImpl m_loggerAdmin;
    private ConfigurationListenerImpl m_configurationListener;

    private static int getMaxSize(BundleContext context) {
        int maxSize = 100;
        String maxSizePropValue = context.getProperty(MAX_SIZE_PROPERTY);
        if (maxSizePropValue != null) {
            try {
                maxSize = Integer.parseInt(maxSizePropValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return maxSize;
    }

    private static boolean getStoreDebug(BundleContext context) {
        boolean storeDebug = false;
        String storeDebugPropValue = context.getProperty(STORE_DEBUG_PROPERTY);
        if (storeDebugPropValue != null) {
            storeDebug = Boolean.valueOf(storeDebugPropValue);
        }
        return storeDebug;
    }

    private static String getDefaultLogLevel(BundleContext context) {
        return context.getProperty("org.osgi.service.log.admin.loglevel");
    }

    public void start(BundleContext context) throws Exception {
        this.m_log = new Log(Activator.getMaxSize(context), Activator.getStoreDebug(context));
        this.m_loggerAdmin = new LoggerAdminImpl(Activator.getDefaultLogLevel(context), this.m_log);
        context.addBundleListener((BundleListener)this.m_log);
        context.addFrameworkListener((FrameworkListener)this.m_log);
        context.addServiceListener((ServiceListener)this.m_log);
        ServiceRegistration serviceRegistration = context.registerService(new String[]{LogService.class.getName(), LoggerFactory.class.getName()}, (Object)new LogServiceFactory(this.m_loggerAdmin), null);
        context.registerService(LogReaderService.class.getName(), (Object)new LogReaderServiceFactory(this.m_log), null);
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("osgi.log.service.id", serviceRegistration.getReference().getProperty("service.id"));
        context.registerService(LoggerAdmin.class.getName(), (Object)this.m_loggerAdmin, properties);
        try {
            this.m_configurationListener = new ConfigurationListenerImpl(context, this.m_log, this.m_loggerAdmin);
        }
        catch (Exception e) {
            this.m_log.log(this.getClass().getName(), context.getBundle(), null, LogLevel.ERROR, "An error occured while setting up the configuration listener.", e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.m_configurationListener != null) {
            this.m_configurationListener.close();
        }
        this.m_log.close();
    }
}

