/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.junit4osgi.command;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.felix.ipojo.junit4osgi.OSGiJunitRunner;
import org.apache.felix.shell.Command;

public class JunitCommand
implements Command {
    private OSGiJunitRunner m_runner;

    private List getNamesFromTests(List list) {
        ArrayList<String> names = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof TestCase) {
                names.add(((TestCase)list.get(i)).getName());
            }
            if (!(list.get(i) instanceof TestSuite)) continue;
            String name = ((TestSuite)list.get(i)).getName();
            if (name == null) {
                name = ((TestSuite)list.get(i)).toString();
            }
            names.add(name);
        }
        return names;
    }

    public void execute(String line, PrintStream out, PrintStream err) {
        line = line.substring(this.getName().length()).trim();
        List tr = null;
        if (line.equals("all")) {
            if (this.m_runner.getTests() == null) {
                err.println("No tests to execute");
                return;
            }
            out.println("Executing " + this.getNamesFromTests(this.m_runner.getTests()));
            tr = this.m_runner.run();
        } else {
            try {
                Long bundleId = new Long(line);
                if (this.m_runner.getTests(bundleId.longValue()) == null) {
                    err.println("No tests to execute");
                    return;
                }
                out.println("Executing " + this.getNamesFromTests(this.m_runner.getTests(bundleId.longValue())));
                tr = this.m_runner.run(bundleId.longValue());
            }
            catch (NumberFormatException e) {
                err.println("Unable to parse id " + line);
                return;
            }
        }
        ListIterator it = tr.listIterator();
        while (it.hasNext()) {
            TestResult result = (TestResult)it.next();
            if (result.failureCount() == 0) continue;
            TestFailure fail = (TestFailure)result.failures().nextElement();
            out.println(fail.trace());
            return;
        }
    }

    public String getName() {
        return "junit";
    }

    public String getShortDescription() {
        return "launch junit tests";
    }

    public String getUsage() {
        return "junit <bundleid> | junit all";
    }
}

