/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.httplite.osgi;

import java.util.Dictionary;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import org.apache.felix.httplite.osgi.Logger;
import org.apache.felix.httplite.servlet.ServletConfigImpl;
import org.apache.felix.httplite.servlet.ServletContextImpl;
import org.osgi.service.http.HttpContext;

public class ServiceRegistration {
    private final Servlet m_servlet;
    private final Dictionary m_initparams;
    private final HttpContext m_context;
    private final String m_alias;
    private final Logger m_logger;
    private boolean m_initialized;
    private boolean m_isServlet;
    private final String m_name;
    private ServletConfigImpl m_servletConfigImpl;

    public ServiceRegistration(String alias, Servlet servlet, Dictionary initparams, HttpContext context, Logger logger) {
        this.m_alias = alias;
        this.m_name = null;
        this.m_servlet = servlet;
        this.m_initparams = initparams;
        this.m_context = context;
        this.m_logger = logger;
        this.m_initialized = false;
        this.m_isServlet = true;
    }

    public ServiceRegistration(String alias, String name, HttpContext context, Logger logger) {
        this.m_alias = alias;
        this.m_name = name;
        this.m_logger = logger;
        this.m_servlet = null;
        this.m_initparams = null;
        this.m_context = context;
        this.m_isServlet = false;
    }

    public final boolean isServlet() {
        return this.m_isServlet;
    }

    public final String getAlias() {
        return this.m_alias;
    }

    public final String getName() {
        return this.m_name;
    }

    public final boolean hasBeenInitialized() {
        return this.m_initialized;
    }

    public final void setInitialized() {
        if (this.m_initialized) {
            throw new IllegalStateException("Servlet has already been initialized.");
        }
        this.m_initialized = true;
    }

    public final Servlet getServlet() {
        return this.m_servlet;
    }

    public final Dictionary getInitparams() {
        return this.m_initparams;
    }

    public final HttpContext getContext() {
        return this.m_context;
    }

    public final ServletConfig getServletConfig() {
        if (this.m_servletConfigImpl == null) {
            this.m_servletConfigImpl = new ServletConfigImpl(this.m_alias, this.m_initparams, new ServletContextImpl(this.m_alias, this.m_context, this.m_initparams, this.m_logger));
        }
        return this.m_servletConfigImpl;
    }
}

