/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.AbstractInfo;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.log.LogService;

public class UpdateCommand
extends Command {
    protected void doExecute(DeploymentSessionImpl session) throws Exception {
        AbstractDeploymentPackage source = session.getSourceAbstractDeploymentPackage();
        AbstractDeploymentPackage targetPackage = session.getTargetAbstractDeploymentPackage();
        BundleContext context = session.getBundleContext();
        LogService log = session.getLog();
        HashMap<String, AbstractInfo> expectedBundles = new HashMap<String, AbstractInfo>();
        AbstractInfo[] bundleInfos = (AbstractInfo[])source.getBundleInfos();
        for (int i = 0; i < bundleInfos.length; ++i) {
            AbstractInfo bundleInfo = bundleInfos[i];
            if (bundleInfo.isMissing()) continue;
            expectedBundles.put(bundleInfo.getPath(), bundleInfo);
        }
        try {
            while (!expectedBundles.isEmpty()) {
                AbstractInfo entry = source.getNextEntry();
                if (entry == null) {
                    throw new DeploymentException(463, "Expected more bundles in the stream: " + expectedBundles.keySet());
                }
                String name = entry.getPath();
                BundleInfoImpl bundleInfo = (BundleInfoImpl)expectedBundles.remove(name);
                if (bundleInfo == null) {
                    if (this.isLocalizationFile(name)) continue;
                    throw new DeploymentException(463, "Resource '" + name + "' is not described in the manifest.");
                }
                String bsn = bundleInfo.getSymbolicName();
                Version sourceVersion = bundleInfo.getVersion();
                Bundle bundle = targetPackage.getBundle(bsn);
                try {
                    if (bundle == null) {
                        bundle = context.installBundle("osgi-dp:" + bsn, (InputStream)new BundleInputStream(source.getCurrentEntryStream()));
                        this.addRollback(new UninstallBundleRunnable(bundle, log));
                    } else {
                        Version currentVersion = this.getVersion(bundle);
                        if (!sourceVersion.equals((Object)currentVersion)) {
                            bundle.update((InputStream)new BundleInputStream(source.getCurrentEntryStream()));
                            this.addRollback(new UpdateBundleRunnable(bundle, targetPackage, log));
                        }
                    }
                }
                catch (Exception be) {
                    if (this.isCancelled()) {
                        return;
                    }
                    throw new DeploymentException(463, "Could not install new bundle '" + name + "' (" + bsn + ")", be);
                }
                if (!bundle.getSymbolicName().equals(bsn)) {
                    throw new DeploymentException(457, "Installed/updated bundle symbolicname (" + bundle.getSymbolicName() + ") do not match what was installed/updated: " + bsn);
                }
                Version targetVersion = this.getVersion(bundle);
                if (sourceVersion.equals((Object)targetVersion)) continue;
                throw new DeploymentException(463, "Installed/updated bundle version (" + targetVersion + ") do not match what was installed/updated: " + sourceVersion + ", offending bundle = " + bsn);
            }
        }
        catch (IOException e) {
            throw new DeploymentException(463, "Problem while reading stream", e);
        }
    }

    private Version getVersion(Bundle bundle) {
        return Version.parseVersion((String)((String)bundle.getHeaders().get("Bundle-Version")));
    }

    private boolean isLocalizationFile(String name) {
        return name.startsWith("OSGI-INF/l10n/");
    }

    private final class BundleInputStream
    extends InputStream {
        private final InputStream m_inputStream;

        private BundleInputStream(InputStream jarInputStream) {
            this.m_inputStream = jarInputStream;
        }

        public int read() throws IOException {
            this.checkCancel();
            return this.m_inputStream.read();
        }

        public int read(byte[] buffer) throws IOException {
            this.checkCancel();
            return this.m_inputStream.read(buffer);
        }

        public int read(byte[] buffer, int off, int len) throws IOException {
            this.checkCancel();
            return this.m_inputStream.read(buffer, off, len);
        }

        private void checkCancel() throws IOException {
            if (UpdateCommand.this.isCancelled()) {
                throw new IOException("Stream was cancelled");
            }
        }
    }

    private static class UpdateBundleRunnable
    extends AbstractAction {
        private final AbstractDeploymentPackage m_targetPackage;
        private final Bundle m_bundle;
        private final LogService m_log;

        public UpdateBundleRunnable(Bundle bundle, AbstractDeploymentPackage targetPackage, LogService log) {
            this.m_bundle = bundle;
            this.m_targetPackage = targetPackage;
            this.m_log = log;
        }

        protected void doRun() throws Exception {
            InputStream is = null;
            try {
                is = this.m_targetPackage.getBundleStream(this.m_bundle.getSymbolicName());
                if (is == null) {
                    throw new RuntimeException("Unable to get inputstream for bundle " + this.m_bundle.getSymbolicName());
                }
                this.m_bundle.update(is);
            }
            catch (Throwable throwable) {
                Command.closeSilently(is);
                throw throwable;
            }
            Command.closeSilently(is);
        }

        protected void onFailure(Exception e) {
            this.m_log.log(2, "Could not rollback update of bundle '" + this.m_bundle.getSymbolicName() + "'", (Throwable)e);
        }
    }

    private static class UninstallBundleRunnable
    extends AbstractAction {
        private final Bundle m_bundle;
        private final LogService m_log;

        public UninstallBundleRunnable(Bundle bundle, LogService log) {
            this.m_bundle = bundle;
            this.m_log = log;
        }

        protected void doRun() throws Exception {
            this.m_bundle.uninstall();
        }

        protected void onFailure(Exception e) {
            this.m_log.log(2, "Could not rollback update of bundle '" + this.m_bundle.getSymbolicName() + "'", (Throwable)e);
        }
    }
}

