/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.impl.base;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.apache.felix.atomos.Atomos;
import org.apache.felix.atomos.impl.base.AtomosBase;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.connect.ConnectModule;
import org.osgi.framework.connect.ModuleConnector;

public class AtomosModuleConnector
implements ModuleConnector {
    final AtomosBase atomos;

    public AtomosModuleConnector() {
        this(null);
    }

    public AtomosModuleConnector(AtomosBase atomos) {
        if (atomos == null) {
            atomos = (AtomosBase)Atomos.newAtomos();
        }
        this.atomos = atomos;
    }

    public Optional<BundleActivator> newBundleActivator() {
        this.atomos.debug("Creating Atomos activator", new Object[0]);
        return Optional.of(new BundleActivator(){

            public void start(BundleContext bc) throws Exception {
                AtomosModuleConnector.this.atomos.start(bc);
            }

            public void stop(BundleContext bc) throws Exception {
                AtomosModuleConnector.this.atomos.stop(bc);
            }
        });
    }

    public Optional<ConnectModule> connect(String location) {
        this.atomos.debug("Framework is attempting to connect location: %s", location);
        AtomosBase.AtomosLayerBase.AtomosContentBase atomosBundle = this.atomos.getByConnectLocation(location, false);
        if (atomosBundle == null) {
            return Optional.empty();
        }
        this.atomos.addManagingConnected(atomosBundle, location);
        return Optional.of(atomosBundle::getConnectContent);
    }

    public void initialize(File storage, Map<String, String> configuration) {
        this.atomos.initialize(storage, configuration);
    }
}

