/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.util.HashSet;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesReadOnlyException;
import org.apache.datasketches.hll.AbstractHllArray;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.IntMemoryPairIterator;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectHllSketchTest {
    @Test
    public void checkNoWriteAccess() {
        DirectHllSketchTest.noWriteAccess(TgtHllType.HLL_4, 7);
        DirectHllSketchTest.noWriteAccess(TgtHllType.HLL_4, 24);
        DirectHllSketchTest.noWriteAccess(TgtHllType.HLL_4, 25);
        DirectHllSketchTest.noWriteAccess(TgtHllType.HLL_6, 25);
        DirectHllSketchTest.noWriteAccess(TgtHllType.HLL_8, 25);
    }

    private static void noWriteAccess(TgtHllType tgtHllType, int n) {
        int lgConfigK = 8;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgConfigK, (TgtHllType)tgtHllType);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketch sk = new HllSketch(lgConfigK, tgtHllType, wmem);
        for (int i = 0; i < n; ++i) {
            sk.update((long)i);
        }
        HllSketch sk2 = HllSketch.wrap((Memory)wmem);
        try {
            sk2.update(1L);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
    }

    @Test
    public void checkCompactToUpdatable() {
        int lgConfigK = 15;
        int n = 0x100000;
        TgtHllType type = TgtHllType.HLL_4;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgConfigK, (TgtHllType)type);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketch sk = new HllSketch(lgConfigK, type, wmem);
        for (int i = 0; i < n; ++i) {
            sk.update((long)i);
        }
        byte[] cByteArr = sk.toCompactByteArray();
        Memory cmem = Memory.wrap((byte[])cByteArr);
        byte[] uByteArr = sk.toUpdatableByteArray();
        AbstractHllArray absArr = (AbstractHllArray)sk.hllSketchImpl;
        int auxStart = absArr.auxStart;
        int auxArrInts = 1 << absArr.getAuxHashMap().getLgAuxArrInts();
        HashSet<Integer> set = new HashSet<Integer>();
        IntMemoryPairIterator itr = new IntMemoryPairIterator(uByteArr, (long)auxStart, auxArrInts, lgConfigK);
        int validCount = 0;
        while (itr.nextValid()) {
            set.add(itr.getPair());
            ++validCount;
        }
        HllSketch sk2 = HllSketch.wrap((Memory)cmem);
        byte[] uByteArr2 = sk2.toUpdatableByteArray();
        IntMemoryPairIterator itr2 = new IntMemoryPairIterator(uByteArr2, (long)auxStart, auxArrInts, lgConfigK);
        int validCount2 = 0;
        while (itr2.nextValid()) {
            boolean exists = set.contains(itr2.getPair());
            if (!exists) continue;
            ++validCount2;
        }
        Assert.assertEquals((int)validCount, (int)validCount2);
    }

    @Test
    public void checkPutKxQ1_Misc() {
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)4, (TgtHllType)TgtHllType.HLL_4);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketch sk = new HllSketch(4, TgtHllType.HLL_4, wmem);
        for (int i = 0; i < 8; ++i) {
            sk.update((long)i);
        }
        Assert.assertTrue((sk.getCurMode() == CurMode.HLL ? 1 : 0) != 0);
        AbstractHllArray absArr = (AbstractHllArray)sk.hllSketchImpl;
        absArr.putKxQ1(1.0);
        Assert.assertEquals((double)absArr.getKxQ1(), (double)1.0);
        absArr.putKxQ1(0.0);
        WritableMemory mem = wmem;
        HllSketch sk2 = HllSketch.wrap((Memory)mem);
        try {
            sk2.reset();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkToCompactByteArr() {
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)4, (TgtHllType)TgtHllType.HLL_4);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketch sk = new HllSketch(4, TgtHllType.HLL_4, wmem);
        for (int i = 0; i < 8; ++i) {
            sk.update((long)i);
        }
        byte[] compByteArr = sk.toCompactByteArray();
        Memory compMem = Memory.wrap((byte[])compByteArr);
        HllSketch sk2 = HllSketch.wrap((Memory)compMem);
        byte[] compByteArr2 = sk2.toCompactByteArray();
        Assert.assertEquals((byte[])compByteArr2, (byte[])compByteArr);
    }

    @Test
    public void checkToUpdatableByteArr() {
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)4, (TgtHllType)TgtHllType.HLL_4);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketch sk = new HllSketch(4, TgtHllType.HLL_4, wmem);
        for (int i = 0; i < 8; ++i) {
            sk.update((long)i);
        }
        byte[] udByteArr = sk.toUpdatableByteArray();
        byte[] compByteArr = sk.toCompactByteArray();
        Memory compMem = Memory.wrap((byte[])compByteArr);
        HllSketch sk2 = HllSketch.wrap((Memory)compMem);
        byte[] udByteArr2 = sk2.toUpdatableByteArray();
        Assert.assertEquals((byte[])udByteArr2, (byte[])udByteArr);
    }

    @Test
    public void printlnTest() {
        DirectHllSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

