/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.config;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;

public class PersistedSecuritySetting
implements EncodingSupport {
    private long storeId;
    private SimpleString addressMatch;
    private SimpleString sendRoles;
    private SimpleString consumeRoles;
    private SimpleString createDurableQueueRoles;
    private SimpleString deleteDurableQueueRoles;
    private SimpleString createNonDurableQueueRoles;
    private SimpleString deleteNonDurableQueueRoles;
    private SimpleString manageRoles;
    private SimpleString browseRoles;
    private SimpleString createAddressRoles;
    private SimpleString deleteAddressRoles;
    private SimpleString viewRoles;
    private SimpleString editRoles;

    public PersistedSecuritySetting() {
    }

    public PersistedSecuritySetting(String addressMatch, String sendRoles, String consumeRoles, String createDurableQueueRoles, String deleteDurableQueueRoles, String createNonDurableQueueRoles, String deleteNonDurableQueueRoles, String manageRoles, String browseRoles, String createAddressRoles, String deleteAddressRoles, String viewRoles, String editRoles) {
        this.addressMatch = SimpleString.of((String)addressMatch);
        this.sendRoles = SimpleString.of((String)sendRoles);
        this.consumeRoles = SimpleString.of((String)consumeRoles);
        this.createDurableQueueRoles = SimpleString.of((String)createDurableQueueRoles);
        this.deleteDurableQueueRoles = SimpleString.of((String)deleteDurableQueueRoles);
        this.createNonDurableQueueRoles = SimpleString.of((String)createNonDurableQueueRoles);
        this.deleteNonDurableQueueRoles = SimpleString.of((String)deleteNonDurableQueueRoles);
        this.manageRoles = SimpleString.of((String)manageRoles);
        this.browseRoles = SimpleString.of((String)browseRoles);
        this.createAddressRoles = SimpleString.of((String)createAddressRoles);
        this.deleteAddressRoles = SimpleString.of((String)deleteAddressRoles);
        this.viewRoles = SimpleString.of((String)viewRoles);
        this.editRoles = SimpleString.of((String)editRoles);
    }

    public long getStoreId() {
        return this.storeId;
    }

    public void setStoreId(long id) {
        this.storeId = id;
    }

    public SimpleString getAddressMatch() {
        return this.addressMatch;
    }

    public String getSendRoles() {
        return this.stringFrom(this.sendRoles);
    }

    public String getConsumeRoles() {
        return this.stringFrom(this.consumeRoles);
    }

    public String getCreateDurableQueueRoles() {
        return this.stringFrom(this.createDurableQueueRoles);
    }

    public String getDeleteDurableQueueRoles() {
        return this.stringFrom(this.deleteDurableQueueRoles);
    }

    public String getCreateNonDurableQueueRoles() {
        return this.stringFrom(this.createNonDurableQueueRoles);
    }

    public String getDeleteNonDurableQueueRoles() {
        return this.stringFrom(this.deleteNonDurableQueueRoles);
    }

    public String getManageRoles() {
        return this.stringFrom(this.manageRoles);
    }

    public String getBrowseRoles() {
        return this.stringFrom(this.browseRoles);
    }

    public String getCreateAddressRoles() {
        return this.stringFrom(this.createAddressRoles);
    }

    public String getDeleteAddressRoles() {
        return this.stringFrom(this.deleteAddressRoles);
    }

    public String getViewRoles() {
        return this.stringFrom(this.viewRoles);
    }

    public String getEditRoles() {
        return this.stringFrom(this.editRoles);
    }

    private String stringFrom(SimpleString possiblyNullSimpleString) {
        return possiblyNullSimpleString != null ? possiblyNullSimpleString.toString() : null;
    }

    public void encode(ActiveMQBuffer buffer) {
        if (this.addressMatch == null) {
            this.addressMatch = SimpleString.of((String)"");
        }
        buffer.writeSimpleString(this.addressMatch);
        buffer.writeNullableSimpleString(this.sendRoles);
        buffer.writeNullableSimpleString(this.consumeRoles);
        buffer.writeNullableSimpleString(this.createDurableQueueRoles);
        buffer.writeNullableSimpleString(this.deleteDurableQueueRoles);
        buffer.writeNullableSimpleString(this.createNonDurableQueueRoles);
        buffer.writeNullableSimpleString(this.deleteNonDurableQueueRoles);
        buffer.writeNullableSimpleString(this.manageRoles);
        buffer.writeNullableSimpleString(this.browseRoles);
        buffer.writeNullableSimpleString(this.createAddressRoles);
        buffer.writeNullableSimpleString(this.deleteAddressRoles);
        buffer.writeNullableSimpleString(this.viewRoles);
        buffer.writeNullableSimpleString(this.editRoles);
    }

    public int getEncodeSize() {
        return (this.addressMatch == null ? 4 : this.addressMatch.sizeof()) + (this.sendRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.sendRoles)) + (this.consumeRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.consumeRoles)) + (this.createDurableQueueRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.createDurableQueueRoles)) + (this.deleteDurableQueueRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.deleteDurableQueueRoles)) + (this.createNonDurableQueueRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.createNonDurableQueueRoles)) + (this.deleteNonDurableQueueRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.deleteNonDurableQueueRoles)) + (this.manageRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.manageRoles)) + (this.browseRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.browseRoles)) + (this.createAddressRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.createAddressRoles)) + (this.deleteAddressRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.deleteAddressRoles)) + (this.viewRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.viewRoles)) + (this.editRoles == null ? 1 : SimpleString.sizeofNullableString((SimpleString)this.editRoles));
    }

    public void decode(ActiveMQBuffer buffer) {
        this.addressMatch = buffer.readSimpleString();
        this.sendRoles = buffer.readNullableSimpleString();
        this.consumeRoles = buffer.readNullableSimpleString();
        this.createDurableQueueRoles = buffer.readNullableSimpleString();
        this.deleteDurableQueueRoles = buffer.readNullableSimpleString();
        this.createNonDurableQueueRoles = buffer.readNullableSimpleString();
        this.deleteNonDurableQueueRoles = buffer.readNullableSimpleString();
        this.manageRoles = buffer.readNullableSimpleString();
        this.browseRoles = buffer.readNullableSimpleString();
        this.createAddressRoles = buffer.readNullableSimpleString();
        this.deleteAddressRoles = buffer.readNullableSimpleString();
        if (buffer.readableBytes() > 0) {
            this.viewRoles = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.editRoles = buffer.readNullableSimpleString();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addressMatch == null ? 0 : this.addressMatch.hashCode());
        result = 31 * result + (this.consumeRoles == null ? 0 : this.consumeRoles.hashCode());
        result = 31 * result + (this.createDurableQueueRoles == null ? 0 : this.createDurableQueueRoles.hashCode());
        result = 31 * result + (this.createNonDurableQueueRoles == null ? 0 : this.createNonDurableQueueRoles.hashCode());
        result = 31 * result + (this.deleteDurableQueueRoles == null ? 0 : this.deleteDurableQueueRoles.hashCode());
        result = 31 * result + (this.deleteNonDurableQueueRoles == null ? 0 : this.deleteNonDurableQueueRoles.hashCode());
        result = 31 * result + (this.manageRoles == null ? 0 : this.manageRoles.hashCode());
        result = 31 * result + (this.browseRoles == null ? 0 : this.browseRoles.hashCode());
        result = 31 * result + (this.createAddressRoles == null ? 0 : this.createAddressRoles.hashCode());
        result = 31 * result + (this.deleteAddressRoles == null ? 0 : this.deleteAddressRoles.hashCode());
        result = 31 * result + (this.sendRoles == null ? 0 : this.sendRoles.hashCode());
        result = 31 * result + (this.viewRoles == null ? 0 : this.viewRoles.hashCode());
        result = 31 * result + (this.editRoles == null ? 0 : this.editRoles.hashCode());
        result = 31 * result + (int)(this.storeId ^ this.storeId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistedSecuritySetting other = (PersistedSecuritySetting)obj;
        if (this.addressMatch == null ? other.addressMatch != null : !this.addressMatch.equals((Object)other.addressMatch)) {
            return false;
        }
        if (this.consumeRoles == null ? other.consumeRoles != null : !this.consumeRoles.equals((Object)other.consumeRoles)) {
            return false;
        }
        if (this.createDurableQueueRoles == null ? other.createDurableQueueRoles != null : !this.createDurableQueueRoles.equals((Object)other.createDurableQueueRoles)) {
            return false;
        }
        if (this.createNonDurableQueueRoles == null ? other.createNonDurableQueueRoles != null : !this.createNonDurableQueueRoles.equals((Object)other.createNonDurableQueueRoles)) {
            return false;
        }
        if (this.deleteDurableQueueRoles == null ? other.deleteDurableQueueRoles != null : !this.deleteDurableQueueRoles.equals((Object)other.deleteDurableQueueRoles)) {
            return false;
        }
        if (this.deleteNonDurableQueueRoles == null ? other.deleteNonDurableQueueRoles != null : !this.deleteNonDurableQueueRoles.equals((Object)other.deleteNonDurableQueueRoles)) {
            return false;
        }
        if (this.manageRoles == null ? other.manageRoles != null : !this.manageRoles.equals((Object)other.manageRoles)) {
            return false;
        }
        if (this.browseRoles == null ? other.browseRoles != null : !this.browseRoles.equals((Object)other.browseRoles)) {
            return false;
        }
        if (this.createAddressRoles == null ? other.createAddressRoles != null : !this.createAddressRoles.equals((Object)other.createAddressRoles)) {
            return false;
        }
        if (this.deleteAddressRoles == null ? other.deleteAddressRoles != null : !this.deleteAddressRoles.equals((Object)other.deleteAddressRoles)) {
            return false;
        }
        if (this.sendRoles == null ? other.sendRoles != null : !this.sendRoles.equals((Object)other.sendRoles)) {
            return false;
        }
        if (this.viewRoles == null ? other.viewRoles != null : !this.viewRoles.equals((Object)other.viewRoles)) {
            return false;
        }
        if (this.editRoles == null ? other.editRoles != null : !this.editRoles.equals((Object)other.editRoles)) {
            return false;
        }
        return this.storeId == other.storeId;
    }

    public String toString() {
        return "PersistedSecuritySetting [storeId=" + this.storeId + ", addressMatch=" + String.valueOf(this.addressMatch) + ", sendRoles=" + String.valueOf(this.sendRoles) + ", consumeRoles=" + String.valueOf(this.consumeRoles) + ", createDurableQueueRoles=" + String.valueOf(this.createDurableQueueRoles) + ", deleteDurableQueueRoles=" + String.valueOf(this.deleteDurableQueueRoles) + ", createNonDurableQueueRoles=" + String.valueOf(this.createNonDurableQueueRoles) + ", deleteNonDurableQueueRoles=" + String.valueOf(this.deleteNonDurableQueueRoles) + ", manageRoles=" + String.valueOf(this.manageRoles) + ", browseRoles=" + String.valueOf(this.browseRoles) + ", createAddressRoles=" + String.valueOf(this.createAddressRoles) + ", deleteAddressRoles=" + String.valueOf(this.deleteAddressRoles) + ", viewRoles=" + String.valueOf(this.viewRoles) + ", editRoles=" + String.valueOf(this.editRoles) + "]";
    }
}

