/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandles;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.security.ActiveMQPrincipal;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.IPV6Util;
import org.apache.activemq.artemis.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int DEFAULT_WAIT_MILLIS = 10000;
    protected final Channel channel;
    private final BaseConnectionLifeCycleListener<?> listener;
    private final boolean directDeliver;
    private final Map<String, Object> configuration;
    private final List<ReadyListener> readyListeners = new ArrayList<ReadyListener>();
    private static final FastThreadLocal<ArrayList<ReadyListener>> localListenersPool = new FastThreadLocal();
    private final boolean batchingEnabled;
    private boolean closed;
    private RemotingConnection protocolConnection;
    private boolean ready = true;

    public NettyConnection(Map<String, Object> configuration, Channel channel, BaseConnectionLifeCycleListener<?> listener, boolean batchingEnabled, boolean directDeliver) {
        Preconditions.checkNotNull((Object)channel);
        this.configuration = configuration;
        this.channel = channel;
        this.listener = listener;
        this.directDeliver = directDeliver;
        this.batchingEnabled = batchingEnabled;
    }

    @Override
    public EventLoop getEventLoop() {
        return this.channel.eventLoop();
    }

    private static void waitFor(ChannelPromise promise, long millis) {
        try {
            boolean completed = promise.await(millis);
            if (!completed) {
                ActiveMQClientLogger.LOGGER.timeoutFlushingPacket();
            }
        }
        catch (InterruptedException e) {
            throw new ActiveMQInterruptedException((Throwable)e);
        }
    }

    private static long batchBufferSize(Channel channel) {
        ChannelOutboundBuffer outboundBuffer = channel.unsafe().outboundBuffer();
        if (outboundBuffer == null) {
            return 0L;
        }
        return outboundBuffer.totalPendingWriteBytes();
    }

    public final Channel getNettyChannel() {
        return this.channel;
    }

    @Override
    public final void setAutoRead(boolean autoRead) {
        this.channel.config().setAutoRead(autoRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isWritable(ReadyListener callback) {
        List<ReadyListener> list = this.readyListeners;
        synchronized (list) {
            if (!this.ready) {
                this.readyListeners.add(callback);
            }
            return this.ready;
        }
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void fireReady(boolean ready) {
        ArrayList<ReadyListener> readyToCall = (ArrayList<ReadyListener>)localListenersPool.get();
        if (readyToCall != null) {
            localListenersPool.set(null);
        }
        List<ReadyListener> list = this.readyListeners;
        synchronized (list) {
            this.ready = ready;
            if (ready) {
                int size = this.readyListeners.size();
                if (readyToCall != null) {
                    readyToCall.ensureCapacity(size);
                }
                try {
                    for (int i = 0; i < size; ++i) {
                        ReadyListener readyListener2 = this.readyListeners.get(i);
                        if (readyListener2 == null) {
                            break;
                        }
                        if (readyToCall == null) {
                            readyToCall = new ArrayList<ReadyListener>(size);
                        }
                        readyToCall.add(readyListener2);
                    }
                }
                finally {
                    this.readyListeners.clear();
                }
            }
        }
        if (readyToCall != null) {
            try {
                readyToCall.forEach(readyListener -> {
                    try {
                        readyListener.readyForWriting();
                    }
                    catch (Throwable logOnly) {
                        ActiveMQClientLogger.LOGGER.failedToSetChannelReadyForWriting(logOnly);
                    }
                });
            }
            catch (Throwable t) {
                ActiveMQClientLogger.LOGGER.failedToSetChannelReadyForWriting(t);
            }
            finally {
                readyToCall.clear();
                if (localListenersPool.get() != null) {
                    localListenersPool.set((Object)readyToCall);
                }
            }
        }
    }

    @Override
    public final void forceClose() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Throwable e) {
                ActiveMQClientLogger.LOGGER.failedForceClose(e);
            }
        }
    }

    public final Channel getChannel() {
        return this.channel;
    }

    @Override
    public final RemotingConnection getProtocolConnection() {
        return this.protocolConnection;
    }

    @Override
    public final void setProtocolConnection(RemotingConnection protocolConnection) {
        this.protocolConnection = protocolConnection;
    }

    @Override
    public final void close() {
        if (this.closed) {
            return;
        }
        EventLoop eventLoop = this.channel.eventLoop();
        boolean inEventLoop = eventLoop.inEventLoop();
        if (!inEventLoop) {
            this.closeChannel(this.channel, false);
        } else {
            eventLoop.execute(() -> this.closeChannel(this.channel, true));
        }
        this.closed = true;
        this.listener.connectionDestroyed(this.getID(), false);
    }

    @Override
    public ActiveMQBuffer createTransportBuffer(int size) {
        try {
            return new ChannelBufferWrapper(this.channel.alloc().directBuffer(size), true);
        }
        catch (OutOfMemoryError oom) {
            long totalPendingWriteBytes = NettyConnection.batchBufferSize(this.channel);
            logger.warn("Trying to allocate {} bytes, System is throwing OutOfMemoryError on NettyConnection {}, there are currently pendingWrites: [NETTY] -> {} causes: {}", new Object[]{size, this, totalPendingWriteBytes, oom.getMessage(), oom});
            throw oom;
        }
    }

    @Override
    public final Object getID() {
        return this.channel.id();
    }

    @Override
    public final void checkFlushBatchBuffer() {
        if (this.batchingEnabled && NettyConnection.batchBufferSize(this.channel) > 0L) {
            this.channel.flush();
        }
    }

    @Override
    public final void write(ActiveMQBuffer buffer) {
        this.write(buffer, false, false);
    }

    @Override
    public void write(ActiveMQBuffer buffer, boolean requestFlush) {
        Channel channel = this.channel;
        ByteBuf bytes = buffer.byteBuf();
        if (requestFlush) {
            channel.writeAndFlush((Object)bytes, channel.voidPromise());
        } else {
            channel.write((Object)bytes, channel.voidPromise());
        }
    }

    @Override
    public void flush() {
        this.checkConnectionState();
        this.channel.flush();
    }

    @Override
    public final void write(ActiveMQBuffer buffer, boolean flush, boolean batched) {
        this.write(buffer, flush, batched, null);
    }

    private void checkConnectionState() {
        if (this.closed || !this.channel.isActive()) {
            throw new IllegalStateException("Connection " + this.getID() + " closed or disconnected");
        }
    }

    @Override
    public final boolean blockUntilWritable(long timeout, TimeUnit timeUnit) {
        boolean canWrite;
        this.checkConnectionState();
        boolean isAllowedToBlock = this.isAllowedToBlock();
        if (!isAllowedToBlock) {
            if (timeout > 0L) {
                if (Env.isTestEnv()) {
                    logger.warn("FAILURE! The code is using blockUntilWritable inside a Netty worker, which would block. The code will probably need fixing!", (Throwable)new Exception("trace"));
                }
                logger.debug("Calling blockUntilWritable using a thread where it's not allowed");
            }
            return this.channel.isWritable();
        }
        long timeoutNanos = timeUnit.toNanos(timeout);
        long deadline = System.nanoTime() + timeoutNanos;
        long parkNanos = timeoutNanos >= 1000000L ? 100000L : 1000L;
        while (!(canWrite = this.channel.isWritable()) && System.nanoTime() - deadline < 0L) {
            this.checkConnectionState();
            LockSupport.parkNanos(parkNanos);
        }
        return canWrite;
    }

    private boolean isAllowedToBlock() {
        EventLoop eventLoop = this.channel.eventLoop();
        boolean inEventLoop = eventLoop.inEventLoop();
        return !inEventLoop;
    }

    @Override
    public final void write(ActiveMQBuffer buffer, boolean flush, boolean batched, ChannelFutureListener futureListener) {
        int readableBytes = buffer.readableBytes();
        Channel channel = this.channel;
        ChannelPromise promise = flush || futureListener != null ? channel.newPromise() : channel.voidPromise();
        ByteBuf bytes = buffer.byteBuf();
        assert (readableBytes >= 0);
        boolean batchingEnabled = this.batchingEnabled;
        ChannelFuture future = batchingEnabled && batched && !flush && channel.isWritable() ? channel.write((Object)bytes, promise) : channel.writeAndFlush((Object)bytes, promise);
        if (futureListener != null) {
            future.addListener((GenericFutureListener)futureListener);
        }
        if (flush) {
            NettyConnection.flushAndWait(channel, promise);
        }
    }

    private static void flushAndWait(Channel channel, ChannelPromise promise) {
        if (!channel.eventLoop().inEventLoop()) {
            NettyConnection.waitFor(promise, 10000L);
        } else {
            logger.debug("Calling write with flush from a thread where it's not allowed");
        }
    }

    @Override
    public final String getRemoteAddress() {
        SocketAddress address = this.channel.remoteAddress();
        if (address == null) {
            return null;
        }
        return address.toString();
    }

    @Override
    public final String getLocalAddress() {
        SocketAddress address = this.channel.localAddress();
        if (address == null) {
            return null;
        }
        return "tcp://" + IPV6Util.encloseHost((String)address.toString());
    }

    @Override
    public final boolean isDirectDeliver() {
        return this.directDeliver;
    }

    @Override
    public final ActiveMQPrincipal getDefaultActiveMQPrincipal() {
        return null;
    }

    @Override
    public final TransportConfiguration getConnectorConfig() {
        if (this.configuration != null) {
            return new TransportConfiguration(NettyConnectorFactory.class.getName(), this.configuration);
        }
        return null;
    }

    @Override
    public final boolean isUsingProtocolHandling() {
        return true;
    }

    @Override
    public boolean isSameTarget(TransportConfiguration ... configs) {
        boolean result = false;
        for (TransportConfiguration cfg : configs) {
            int port2;
            int port1;
            if (cfg == null || !NettyConnectorFactory.class.getName().equals(cfg.getFactoryClassName()) || (port1 = ConfigurationHelper.getIntProperty("port", 61616, this.configuration)) != (port2 = ConfigurationHelper.getIntProperty("port", 61616, cfg.getParams()))) continue;
            Object hostParam = this.configuration.get("host");
            if (hostParam != null) {
                if (hostParam.equals(cfg.getParams().get("host"))) {
                    result = true;
                    break;
                }
                if (!this.isLocalhost((String)this.configuration.get("host")) || !this.isLocalhost((String)cfg.getParams().get("host"))) continue;
                result = true;
                break;
            }
            if (cfg.getParams().get("host") != null) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isLocalhost(String hostname) {
        return "127.0.0.1".equals(hostname) || "localhost".equals(hostname);
    }

    public final String toString() {
        return super.toString() + "[ID=" + this.getID() + ", local= " + this.channel.localAddress() + ", remote=" + this.channel.remoteAddress() + "]";
    }

    private void closeChannel(Channel channel, boolean inEventLoop) {
        this.checkFlushBatchBuffer();
        ChannelFuture closeFuture = channel.close();
        if (!inEventLoop && !closeFuture.awaitUninterruptibly(10000L)) {
            ActiveMQClientLogger.LOGGER.timeoutClosingNettyChannel();
        }
    }
}

