/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.Key;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionProvider;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public class DirectKeyDecryptionAlgorithm
implements KeyDecryptionProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(DirectKeyDecryptionAlgorithm.class);
    private final byte[] contentDecryptionKey;

    public DirectKeyDecryptionAlgorithm(Key contentDecryptionKey) {
        this(contentDecryptionKey.getEncoded());
    }

    public DirectKeyDecryptionAlgorithm(String encodedContentDecryptionKey) {
        this(CryptoUtils.decodeSequence((String)encodedContentDecryptionKey));
    }

    public DirectKeyDecryptionAlgorithm(byte[] contentDecryptionKey) {
        this.contentDecryptionKey = contentDecryptionKey;
    }

    @Override
    public byte[] getDecryptedContentEncryptionKey(JweDecryptionInput jweDecryptionInput) {
        this.validateKeyEncryptionKey(jweDecryptionInput);
        return (byte[])this.contentDecryptionKey.clone();
    }

    @Override
    public KeyAlgorithm getAlgorithm() {
        return KeyAlgorithm.DIRECT;
    }

    protected void validateKeyEncryptionKey(JweDecryptionInput jweDecryptionInput) {
        byte[] encryptedCEK = jweDecryptionInput.getEncryptedCEK();
        if (encryptedCEK != null && encryptedCEK.length > 0) {
            LOG.warning("Unexpected content encryption key");
            throw new JweException(JweException.Error.INVALID_KEY_ALGORITHM);
        }
    }
}

