/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_undertow;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.security.CertificateConstraintsType;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http_undertow.ServerEngine;
import org.apache.cxf.transport.http_undertow.UndertowHTTPHandler;
import org.apache.cxf.transport.http_undertow.UndertowHTTPServerEngine;
import org.apache.cxf.transport.http_undertow.UndertowHTTPServerEngineFactory;
import org.apache.cxf.transport.https.CertConstraintsJaxBUtils;
import org.apache.cxf.transport.servlet.ServletDestination;
import org.apache.cxf.transports.http.configuration.HTTPServerPolicy;

public class UndertowHTTPDestination
extends ServletDestination {
    private static final Logger LOG = LogUtils.getL7dLogger(UndertowHTTPDestination.class);
    protected UndertowHTTPServerEngine engine;
    protected UndertowHTTPServerEngineFactory serverEngineFactory;
    protected URL nurl;
    protected ClassLoader loader;
    protected ServletContext servletContext;
    private boolean configFinalized;

    public UndertowHTTPDestination(Bus bus, DestinationRegistry registry, EndpointInfo ei, UndertowHTTPServerEngineFactory serverEngineFactory) throws IOException {
        super(bus, registry, ei, UndertowHTTPDestination.getAddressValue((EndpointInfo)ei, (boolean)true).getAddress(), true);
        this.serverEngineFactory = serverEngineFactory;
        this.loader = (ClassLoader)bus.getExtension(ClassLoader.class);
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected void retrieveEngine() throws GeneralSecurityException, IOException {
        CertificateConstraintsType constraints;
        if (this.serverEngineFactory == null) {
            return;
        }
        this.nurl = new URL(this.getAddress(this.endpointInfo));
        this.engine = this.serverEngineFactory.retrieveUndertowHTTPServerEngine(this.nurl.getPort());
        if (this.engine == null) {
            this.engine = this.serverEngineFactory.createUndertowHTTPServerEngine(this.nurl.getHost(), this.nurl.getPort(), this.nurl.getProtocol());
        }
        assert (this.engine != null);
        TLSServerParameters serverParameters = this.engine.getTlsServerParameters();
        if (serverParameters != null && serverParameters.getCertConstraints() != null && (constraints = serverParameters.getCertConstraints()) != null) {
            this.certConstraints = CertConstraintsJaxBUtils.createCertConstraints((CertificateConstraintsType)constraints);
        }
        if (!this.nurl.getProtocol().equals(this.engine.getProtocol())) {
            throw new IllegalStateException("Port " + this.engine.getPort() + " is configured with wrong protocol \"" + this.engine.getProtocol() + "\" for \"" + this.nurl + "\"");
        }
    }

    public void finalizeConfig() {
        assert (!this.configFinalized);
        try {
            this.retrieveEngine();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.configFinalized = true;
    }

    protected void activate() {
        super.activate();
        LOG.log(Level.FINE, "Activating receipt of incoming messages");
        if (this.engine != null) {
            UndertowHTTPHandler jhd = this.createUndertowHTTPHandler(this, this.contextMatchOnExact());
            this.engine.addServant(this.nurl, jhd);
        }
    }

    protected UndertowHTTPHandler createUndertowHTTPHandler(UndertowHTTPDestination jhd, boolean cmExact) {
        return new UndertowHTTPHandler(jhd, cmExact);
    }

    protected void deactivate() {
        super.deactivate();
        LOG.log(Level.FINE, "Deactivating receipt of incoming messages");
        if (this.engine != null) {
            this.engine.removeServant(this.nurl);
        }
    }

    protected String getBasePathForFullAddress(String addr) {
        try {
            return new URL(addr).getPath();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected void doService(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doService(this.servletContext, req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doService(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HTTPServerPolicy sp;
        if (context == null) {
            context = this.servletContext;
        }
        if ((sp = this.getServer()).isSetRedirectURL()) {
            resp.sendRedirect(sp.getRedirectURL());
            resp.flushBuffer();
            return;
        }
        ClassLoaderUtils.ClassLoaderHolder origLoader = null;
        Bus origBus = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
        try {
            if (this.loader != null) {
                origLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)this.loader);
            }
            this.invoke(null, context, req, resp);
        }
        finally {
            if (origBus != this.bus) {
                BusFactory.setThreadDefaultBus((Bus)origBus);
            }
            if (origLoader != null) {
                origLoader.reset();
            }
        }
    }

    protected void invokeComplete(ServletContext context, HttpServletRequest req, HttpServletResponse resp, Message m) throws IOException {
        resp.flushBuffer();
        super.invokeComplete(context, req, resp, m);
    }

    public void setServletContext(ServletContext sc) {
        this.servletContext = sc;
    }

    protected Message retrieveFromContinuation(HttpServletRequest req) {
        return (Message)req.getAttribute("cxf.continuation.message");
    }

    protected void setupContinuation(Message inMessage, HttpServletRequest req, HttpServletResponse resp) {
        if (this.engine != null && this.engine.getContinuationsEnabled()) {
            super.setupContinuation(inMessage, req, resp);
        }
    }

    protected String getAddress(EndpointInfo endpointInfo) {
        return endpointInfo.getAddress();
    }

    public ServerEngine getEngine() {
        return this.engine;
    }
}

